! Copyright 2014-2017  Kazuya Ishimura
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!-----------------
  module fmtgrid
!-----------------
!
! Chebyshev polynomial grids of Fm(T)
!
      implicit none
      real(8),parameter :: threshtval=40.0D+00
      real(8) fgrid(0:10,0:8,0:39)
      data fgrid / &
&    9.999999999999997D-01,  -3.333333333332517D-01,   9.999999999672132D-02, &
&   -2.380952375809728D-02,   4.629629215400776D-03,  -7.575738074151474D-04, &
&    1.068318663946678D-04,  -1.321661019195205D-05,   1.445502845528346D-06, &
&   -1.346191555931696D-07,   8.359177095433178D-09,                          &
&    3.333333333333330D-01,  -1.999999999999251D-01,   7.142857142556350D-02, &
&   -1.851851847133708D-02,   3.787878407825154D-03,  -6.410238516496496D-04, &
&    9.258732499720890D-05,  -1.166132910184095D-05,   1.293034002147142D-06, &
&   -1.216586703975084D-07,   7.605455719422545D-09,                          &
&    1.999999999999997D-01,  -1.428571428570737D-01,   5.555555555277717D-02, &
&   -1.515151510793273D-02,   3.205127854050802D-03,  -5.555539025186929D-04, &
&    8.169447982248541D-05,  -1.043352832610067D-05,   1.169649769473840D-06, &
&   -1.109716513120121D-07,   6.976100540425384D-09,                          &
&    1.428571428571426D-01,  -1.111111111110469D-01,   4.545454545196411D-02, &
&   -1.282051278002016D-02,   2.777777451578354D-03,  -4.901945424611731D-04, &
&    7.309489299071485D-05,  -9.439631927916770D-06,   1.067754531315487D-06, &
&   -1.020086613401809D-07,   6.442732885019565D-09,                          &
&    1.111111111111109D-01,  -9.090909090903092D-02,   3.846153845912811D-02, &
&   -1.111111107329977D-02,   2.450980087548036D-03,  -4.385950568634263D-04, &
&    6.613334284327671D-05,  -8.618614566000984D-06,   9.821852919539842D-07, &
&   -9.438399022011406D-08,   5.984985081250934D-09,                          &
&    9.090909090909068D-02,  -7.692307692302067D-02,   3.333333333107275D-02, &
&   -9.803921533164854D-03,   2.192982170445163D-03,  -3.968240514748135D-04, &
&    6.038251203645524D-05,  -7.928980560999458D-06,   9.093101261154456D-07, &
&   -8.781892893297634D-08,   5.587863484248235D-09,                          &
&    7.692307692307671D-02,  -6.666666666661370D-02,   2.941176470375405D-02, &
&   -8.771929791173166D-03,   1.984126715136736D-03,  -3.623175738532406D-04, &
&    5.555182551266131D-05,  -7.341530268331400D-06,   8.464998725200777D-07, &
&   -8.210709001074689D-08,   5.240087715039172D-09,                          &
&    6.666666666666646D-02,  -5.882352941171467D-02,   2.631578947167357D-02, &
&   -7.936507904965053D-03,   1.811593948769707D-03,  -3.333321365580707D-04, &
&    5.143680502146384D-05,  -6.835119804871918D-06,   7.918044416060093D-07, &
&   -7.709238924747064D-08,   4.933009348365527D-09,                          &
&    5.882352941176451D-02,  -5.263157894732101D-02,   2.380952380761852D-02, &
&   -7.246376781703574D-03,   1.666666425844633D-03,  -3.086408411704429D-04, &
&    4.788938044528681D-05,  -6.394062248299522D-06,   7.437468942480577D-07, &
&   -7.265460684609708D-08,   4.659887332077578D-09,                          &
&    9.999999804403062D-01,  -3.333331795066329D-01,   9.999945214435906D-02, &
&   -2.380835646658040D-02,   4.627974123053545D-03,  -7.559317195823215D-04, &
&    1.056671803731972D-04,  -1.262664725252616D-05,   1.238405220343014D-06, &
&   -8.851803258813482D-08,   3.377195277687474D-09,                          &
&    3.333333154954465D-01,  -1.999998597015553D-01,   7.142807169820214D-02, &
&   -1.851745357089845D-02,   3.786368230872050D-03,  -6.395252036866848D-04, &
&    9.152406649933964D-05,  -1.112254096571528D-05,   1.103812047841609D-06, &
&   -7.951387956360949D-08,   3.048410136992257D-09,                          &
&    1.999999836071490D-01,  -1.428570139140801D-01,   5.555509622815113D-02, &
&   -1.515053618827789D-02,   3.203739401942847D-03,  -5.541757847662211D-04, &
&    8.071649039316971D-05,  -9.937789148250056D-06,   9.954767947624604D-07, &
&   -7.216060944303392D-08,   2.777468191990451D-09,                          &
&    1.428571276940043D-01,  -1.111109918326459D-01,   4.545412051972690D-02, &
&   -1.281960706510405D-02,   2.776492663000884D-03,  -4.889191040012299D-04, &
&    7.218957448600776D-05,  -8.980601290016510D-06,   9.064227486510377D-07, &
&   -6.604453426397900D-08,   2.550430870288749D-09,                          &
&    1.111110970069439D-01,  -9.090897995428737D-02,   3.846114315158761D-02, &
&   -1.111026842598710D-02,   2.449784627183934D-03,  -4.374081235299699D-04, &
&    6.529068659292810D-05,  -8.191251789991410D-06,   8.319379684761176D-07, &
&   -6.087900939117593D-08,   2.357483601636212D-09,                          &
&    9.090907772626694D-02,  -7.692297321089544D-02,   3.333296380390122D-02, &
&   -9.803133777755479D-03,   2.191864473437868D-03,  -3.957141842419953D-04, &
&    5.959443687151829D-05,  -7.529213217362370D-06,   7.687268821464298D-07, &
&   -5.645928691372311D-08,   2.191521566492588D-09,                          &
&    7.692306454906629D-02,  -6.666656931309175D-02,   2.941141781276148D-02, &
&   -8.771190239605648D-03,   1.983077318560622D-03,  -3.612754097079739D-04, &
&    5.481171407355613D-05,  -6.966021773316118D-06,   7.144161780347854D-07, &
&   -5.263529788382129D-08,   2.047278223634731D-09,                          &
&    6.666665500830286D-02,  -5.882343768480926D-02,   2.631546261301462D-02, &
&   -7.935811017560233D-03,   1.810605012764161D-03,  -3.323499161492066D-04, &
&    5.073917126088153D-05,  -6.481102641749867D-06,   6.672537875185562D-07, &
&   -4.929458847111058D-08,   1.920768840811676D-09,                          &
&    5.882351839105511D-02,  -5.263149223419733D-02,   2.380921480101416D-02, &
&   -7.245717919168543D-03,   1.665731383449153D-03,  -3.077120632625463D-04, &
&    4.722962625803429D-05,  -6.059215807453830D-06,   6.259183969321669D-07, &
&   -4.635125748438816D-08,   1.808924069613188D-09,                          &
&    9.999970809136866D-01,  -3.333199610447371D-01,   9.997209328011357D-02, &
&   -2.377445002595311D-02,   4.600064987399088D-03,  -7.399629118688166D-04, &
&    9.922510257062176D-05,  -1.081492301556664D-05,   8.981320275910735D-07, &
&   -4.995669146275185D-08,   1.374916130143904D-09,                          &
&    3.333306888091094D-01,  -1.999878830949846D-01,   7.140327850979990D-02, &
&   -1.848672032604810D-02,   3.761065040180030D-03,  -6.250436673204656D-04, &
&    8.568032581948390D-05,  -9.478594644840377D-06,   7.949539808390611D-07, &
&   -4.450156051628649D-08,   1.229843334343841D-09,                          &
&    1.999975833860697D-01,  -1.428460683570587D-01,   5.553243383412646D-02, &
&   -1.512243918324826D-02,   3.180602016194618D-03,  -5.409308446319147D-04, &
&    7.537046777762571D-05,  -8.433474950211744D-06,   7.127771544961399D-07, &
&   -4.010499370390665D-08,   1.112031929956882D-09,                          &
&    1.428549183606487D-01,  -1.111009155480897D-01,   4.543325505738934D-02, &
&   -1.279373389907854D-02,   2.755182878818634D-03,  -4.767180400869185D-04, &
&    6.726386920519590D-05,  -7.594254901889048D-06,   6.458327612312408D-07, &
&   -3.648911130078435D-08,   1.014539816833066D-09,                          &
&    1.111090506933558D-01,  -9.089964618527766D-02,   3.844181294413896D-02, &
&   -1.108629574496878D-02,   2.430037156554148D-03,  -4.260996957413747D-04, &
&    6.072452662637943D-05,  -6.905854089376413D-06,   5.902751951095186D-07, &
&   -3.346474433201564D-08,   9.325778497421249D-10,                          &
&    9.090717221029767D-02,  -7.691428085455762D-02,   3.331496007407632D-02, &
&   -9.780803510915706D-03,   2.173467510350611D-03,  -3.851775931983398D-04, &
&    5.533926045735752D-05,  -6.331158088317770D-06,   5.434458256966122D-07, &
&   -3.089885767282273D-08,   8.627408462650209D-10,                          &
&    7.692128183435188D-02,  -6.665843647375486D-02,   2.939457140240425D-02, &
&   -8.750293228379110D-03,   1.965859144408288D-03,  -3.514126835519147D-04, &
&    5.082812062602497D-05,  -5.844265232922807D-06,   5.034497662410480D-07, &
&   -2.869527952944847D-08,   8.025444287152571D-10,                          &
&    6.666498032219491D-02,  -5.881579712321016D-02,   2.629963460509267D-02, &
&   -7.916175450571224D-03,   1.794424529488559D-03,  -3.230805270466393D-04, &
&    4.699476407194665D-05,  -5.426560465384505D-06,   4.689010804987421D-07, &
&   -2.678282456717568D-08,   7.501352550607752D-10,                          &
&    5.882193946167425D-02,  -5.262428808334796D-02,   2.379428974967414D-02, &
&   -7.227200980335247D-03,   1.650471274058974D-03,  -2.989690362056951D-04, &
&    4.369745241255056D-05,  -5.064327675678296D-06,   4.387632908195667D-07, &
&   -2.510771199914215D-08,   7.041036784281613D-10,                          &
&    9.999444165415510D-01,  -3.331515048022037D-01,   9.972813897902640D-02, &
&   -2.356372197965929D-02,   4.479776593499697D-03,  -6.925337577818703D-04, &
&    8.613900409742428D-05,  -8.319663555045441D-06,   5.834019147074944D-07, &
&   -2.624456984471256D-08,   5.646482971918542D-10,                          &
&    3.332833459373285D-01,  -1.998364205600774D-01,   7.118389080296015D-02, &
&   -1.829717338031598D-02,   3.652843616421752D-03,  -5.823627560467561D-04, &
&    7.390155109353332D-05,  -7.232080879730239D-06,   5.115305175919948D-07, &
&   -2.314302034939995D-08,   4.998283627157455D-10,                          &
&    1.999546029805939D-01,  -1.427085409977546D-01,   5.533319747563730D-02, &
&   -1.495027227131366D-02,   3.082285503941527D-03,  -5.021488308983846D-04, &
&    6.466556753761947D-05,  -6.391365829084271D-06,   4.550895199685683D-07, &
&   -2.068197006334093D-08,   4.480394806493350D-10,                          &
&    1.428155759487906D-01,  -1.109750120732833D-01,   4.525083224372472D-02, &
&   -1.263607236570565D-02,   2.665135473513614D-03,  -4.411920290391218D-04, &
&    5.745605806155906D-05,  -5.722956356996482D-06,   4.096583456746263D-07, &
&   -1.868456661228614D-08,   4.057733320247609D-10,                          &
&    1.110727863946831D-01,  -9.078357985000212D-02,   3.827362252906475D-02, &
&   -1.094091581765013D-02,   2.346992965716723D-03,  -3.933319810673438D-04, &
&    5.167688897954985D-05,  -5.179337784243317D-06,   3.723410134319001D-07, &
&   -1.703283829066333D-08,   3.706619415956903D-10,                          &
&    9.087354483876572D-02,  -7.680664331759864D-02,   3.315896696146602D-02, &
&   -9.645951319573353D-03,   2.096427809505619D-03,  -3.547753763011161D-04, &
&    4.694370208865576D-05,  -4.728867386126935D-06,   3.411660031150527D-07, &
&   -1.564528960939308D-08,   3.410536234575280D-10,                          &
&    7.688993783882297D-02,  -6.655809886510977D-02,   2.924914391688662D-02, &
&   -8.624562188324812D-03,   1.894022735232822D-03,  -3.230607576844787D-04, &
&    4.299787274651510D-05,  -4.349693764521458D-06,   3.147472532290742D-07, &
&   -1.446393128749662D-08,   3.157635925653826D-10,                          &
&    6.663563219345884D-02,  -5.872184124181907D-02,   2.616344526547597D-02, &
&   -7.798420925915803D-03,   1.727139252370743D-03,  -2.965222509214799D-04, &
&    3.965915987487440D-05,  -4.026261182356868D-06,   2.920833056454122D-07, &
&   -1.344644018092596D-08,   2.939212322720631D-10,                          &
&    5.879435036226497D-02,  -5.253595740787104D-02,   2.366624459385809D-02, &
&   -7.116479481258607D-03,   1.587199448023052D-03,  -2.739927675329813D-04, &
&    3.679820111453446D-05,  -3.747205709306437D-06,   2.724333903279522D-07, &
&   -1.256124126252511D-08,   2.748732275985460D-10,                          &
&    9.995933288879559D-01,  -3.322914963988249D-01,   9.877638829974196D-02, &
&   -2.293698504568761D-02,   4.207784122834838D-03,  -6.112403302574453D-04, &
&    6.919147735158933D-05,  -5.886155152124398D-06,   3.530644081516765D-07, &
&   -1.326746030851460D-08,   2.341993306912145D-10,                          &
&    3.329705530224217D-01,  -1.990700768802383D-01,   7.033563602250897D-02, &
&   -1.773848069639054D-02,   3.410332824030012D-03,  -5.098661696190138D-04, &
&    5.878484019783077D-05,  -5.061014713650601D-06,   3.059916726526686D-07, &
&   -1.156070154131994D-08,   2.048372374994605D-10,                          &
&    1.996727652389882D-01,  -1.420179314495080D-01,   5.456865023208947D-02, &
&   -1.444663024647343D-02,   2.863633928203355D-03,  -4.367736566067741D-04, &
&    5.103144694628184D-05,  -4.432892304641234D-06,   2.696453398689300D-07, &
&   -1.023022463050503D-08,   1.817983306338965D-10,                          &
&    1.425592429429332D-01,  -1.103468167671961D-01,   4.455528749626052D-02, &
&   -1.217782180771468D-02,   2.466161947949535D-03,  -3.816918606763955D-04, &
&    4.504537301160485D-05,  -3.939962432621478D-06,   2.408053588628166D-07, &
&   -9.166533931237205D-09,   1.632824326493757D-10,                          &
&    1.108378083748995D-01,  -9.020765458054655D-02,   3.763587777003607D-02, &
&   -1.052069591668766D-02,   2.164510200443795D-03,  -3.387563761592011D-04, &
&    4.029195636438033D-05,  -3.543504182538945D-06,   2.174049841495342D-07, &
&   -8.298202527435686D-09,   1.481024205850943D-10,                          &
&    9.065669443525726D-02,  -7.627509663714985D-02,   3.257030513543478D-02, &
&   -9.258032799978042D-03,   1.927954281394405D-03,  -3.043841372467622D-04, &
&    3.643052280847102D-05,  -3.218126333210152D-06,   1.980624216274647D-07, &
&   -7.576848450755766D-09,   1.354470168352615D-10,                          &
&    7.668865861731966D-02,  -6.606467844626177D-02,   2.870265694009973D-02, &
&   -8.264403611391772D-03,   1.737590917220978D-03,  -2.762668537634283D-04, &
&    3.323428270398585D-05,  -2.946534823359142D-06,   1.818216623555986D-07, &
&   -6.968638176065867D-09,   1.247447013652347D-10,                          &
&    6.644786664357089D-02,  -5.826151396183112D-02,   2.565357095825556D-02, &
&   -7.462364867597106D-03,   1.581164253485137D-03,  -2.528527071317961D-04, &
&    3.054670789067420D-05,  -2.716569544905297D-06,   1.680017717202717D-07, &
&   -6.449257481267039D-09,   1.155822011682396D-10,                          &
&    5.861841922369999D-02,  -5.210461467716449D-02,   2.318844163345569D-02, &
&   -6.801539202346976D-03,   1.450386750174288D-03,  -2.330611854811610D-04, &
&    2.825644061042737D-05,  -2.519445468500062D-06,   1.561054749201950D-07, &
&   -6.000815995494385D-09,   1.076538200075049D-10,                          &
&    9.982901825109971D-01,  -3.297128422075043D-01,   9.647401571188901D-02, &
&   -2.171544342034088D-02,   3.781280110147251D-03,  -5.088385133276033D-04, &
&    5.206909252687442D-05,  -3.917358376039106D-06,   2.040802169068827D-07, &
&   -6.567691905708439D-09,   9.824246874930333D-11,                          &
&    3.318215688370610D-01,  -1.967960717959190D-01,   6.830490285956127D-02, &
&   -1.666086071465344D-02,   3.034009199891052D-03,  -4.194954805733255D-04, &
&    4.367130695407668D-05,  -3.322876195759205D-06,   1.744373821202945D-07, &
&   -5.643651739953278D-09,   8.474190399035463D-11,                          &
&    1.986464467755963D-01,  -1.399863973346469D-01,   5.275417372876038D-02, &
&   -1.348362002639540D-02,   2.527281750732164D-03,  -3.559891042909699D-04, &
&    3.751897205654951D-05,  -2.878640549522157D-06,   1.519905162676878D-07, &
&   -4.937527242495589D-09,   7.435877216591550D-11,                          &
&    1.416326352806201D-01,  -1.085124236536419D-01,   4.291667902888503D-02, &
&   -1.130803841407403D-02,   2.162331401122118D-03,  -3.087086647180941D-04, &
&    3.283617951754479D-05,  -2.535432845329745D-06,   1.344703164950782D-07, &
&   -4.382432804003221D-09,   6.615467273462124D-11,                          &
&    1.099937183240010D-01,  -8.853644126213873D-02,   3.614286985553112D-02, &
&   -9.728110355362968D-03,   1.887615194690471D-03,  -2.722358719914734D-04, &
&    2.916263382161257D-05,  -2.263056982129315D-06,   1.204531662567801D-07, &
&   -3.935775170029054D-09,   5.952584286900560D-11,                          &
&    8.988194135294828D-02,  -7.474102159752085D-02,   3.119968298764988D-02, &
&   -8.530347999166889D-03,   1.673708227580315D-03,  -2.432988166293684D-04, &
&    2.620954629589390D-05,  -2.042071395044206D-06,   1.090062680890637D-07, &
&   -3.569308790789601D-09,   5.406853099462919D-11,                          &
&    7.597293390904775D-02,  -6.464737030961744D-02,   2.743625654124878D-02, &
&   -7.591995835399186D-03,   1.502638372438350D-03,  -2.198122274685336D-04, &
&    2.378732637026950D-05,  -1.859448807485561D-06,   9.949570120861207D-08, &
&   -3.263649083962429D-09,   4.950372002187742D-11,                          &
&    6.578296689054667D-02,  -5.694475847286810D-02,   2.447693220240918D-02, &
&   -6.837571315136852D-03,   1.362832954970989D-03,  -2.003879556042904D-04, &
&    2.176675251364994D-05,  -1.706162012576400D-06,   9.147708512198400D-08, &
&   -3.005096363271575D-09,   4.563307004803580D-11,                          &
&    5.799771648817159D-02,  -5.087530936393225D-02,   2.208987755153006D-02, &
&   -6.218165556514173D-03,   1.246516162315703D-03,  -1.840681114458157D-04, &
&    2.005692989815170D-05,  -1.575774235692406D-06,   8.463049356627241D-08, &
&   -2.783719947177179D-09,   4.231209613266365D-11,                          &
&    9.949800581997457D-01,  -3.242269820944299D-01,   9.237487375046793D-02, &
&   -1.989682172374389D-02,   3.250746234416175D-03,  -4.025017446050836D-04, &
&    3.723881442826783D-05,  -2.496289519860307D-06,   1.145431055193335D-07, &
&   -3.218088776225806D-09,   4.174449550607400D-11,                          &
&    3.289379431745015D-01,  -1.920162075194629D-01,   6.473266085379617D-02, &
&   -1.507571942512067D-02,   2.571503770086665D-03,  -3.267771776789026D-04, &
&    3.073800006948973D-05,  -2.083356482463240D-06,   9.632516514733859D-08, &
&   -2.720938979068096D-09,   3.543568792566380D-11,                          &
&    1.960962746519544D-01,  -1.357586465505200D-01,   4.959409023588854D-02, &
&   -1.208116147333401D-02,   2.118017705185952D-03,  -2.739318312262843D-04, &
&    2.607106732435199D-05,  -1.781317590159388D-06,   8.282904810100835D-08, &
&   -2.349343996861713D-09,   3.068974943139777D-11,                          &
&    1.393494736692700D-01,  -1.047268684219727D-01,   4.008677069032937D-02, &
&   -1.005195678354115D-02,   1.795737101910503D-03,  -2.351974502920391D-04, &
&    2.257926130907760D-05,  -1.552147573450272D-06,   7.248866862951184D-08, &
&   -2.062650129535587D-09,   2.700947464732245D-11,                          &
&    1.079286799605014D-01,  -8.511218626646862D-02,   3.358278484599504D-02, &
&   -8.591672385874639D-03,   1.555904362451697D-03,  -2.057125827427003D-04, &
&    1.987974506647127D-05,  -1.373053386977438D-06,   6.434565201783060D-08, &
&   -1.835624369749135D-09,   2.408317439791146D-11,                          &
&    8.799813005615328D-02,  -7.161700012821276D-02,   2.886385243824513D-02, &
&   -7.493364101880439D-03,   1.370999147899410D-03,  -1.825861787097420D-04, &
&    1.773672404034853D-05,  -1.229659770433356D-06,   5.778567977999215D-08, &
&   -1.651908352754539D-09,   2.170714576810984D-11,                          &
&    7.424188931144924D-02,  -6.177646857351745D-02,   2.528951652760544D-02, &
&   -6.638883301430524D-03,   1.224390516487183D-03,  -1.640012334924374D-04, &
&    1.599794452125973D-05,  -1.112509791744912D-06,   5.239932681515452D-08, &
&   -1.500498847453168D-09,   1.974345560422186D-11,                          &
&    6.418231717335810D-02,  -5.428993536066599D-02,   2.249163182185162D-02, &
&   -5.956074624559395D-03,   1.105474642536686D-03,  -1.487634323929591D-04, &
&    1.456116852790563D-05,  -1.015157128898441D-06,   4.790452941333287D-08, &
&   -1.373757468446471D-09,   1.809581680075933D-11,                          &
&    5.650958361107064D-02,  -4.840695955609936D-02,   2.024391320184887D-02, &
&   -5.398486333147369D-03,   1.007191355069852D-03,  -1.360580905702030D-04, &
&    1.335544069544718D-05,  -9.330725327185118D-07,   4.410135328214135D-08, &
&   -1.266235217047203D-09,   1.669521643310990D-11,                          &
&    9.885122618009851D-01,  -3.150135372590259D-01,   8.646031748217927D-02, &
&   -1.764359675618336D-02,   2.686608743214255D-03,  -3.055091794318217D-04, &
&    2.564145864028023D-05,  -1.544040745312140D-06,   6.315819980176774D-08, &
&   -1.572593942146595D-09,   1.799888197944591D-11,                          &
&    3.233811909781094D-01,  -1.840991666645525D-01,   5.964943222213145D-02, &
&   -1.313885607779920D-02,   2.086487281965568D-03,  -2.433731343795970D-04, &
&    2.076364996961097D-05,  -1.264226718180332D-06,   5.211582412360610D-08, &
&   -1.304980304008936D-09,   1.499891739226071D-11,                          &
&    1.912380961943709D-01,  -1.288359049923717D-01,   4.514861644481824D-02, &
&   -1.038705453156527D-02,   1.693728581811925D-03,  -2.009598647889242D-04, &
&    1.734302257668855D-05,  -1.064434711094254D-06,   4.413249385726852D-08, &
&   -1.109773969346613D-09,   1.279628825986564D-11,                          &
&    1.350414492939876D-01,  -9.858733689860581D-02,   3.614376044748307D-02, &
&   -8.549148386040747D-03,   1.419312737193981D-03,  -1.704496675927394D-04, &
&    1.483395287714362D-05,  -9.159051356580720D-07,   3.814085825306230D-08, &
&   -9.622522950918719D-10,   1.112311548124083D-11,                          &
&    1.040636881627557D-01,  -7.960347602869648D-02,   3.004454615502295D-02, &
&   -7.242996696804195D-03,   1.218052426346051D-03,  -1.475935549736765D-04, &
&    1.292667183362258D-05,  -8.018310677820824D-07,   3.350484375764415D-08, &
&   -8.474804399789886D-10,   9.815992948501456D-12,                          &
&    8.449668069553236D-02,  -6.662600693201040D-02,   2.565786240809414D-02, &
&   -6.271224830696636D-03,   1.064818474249615D-03,  -1.299107744131856D-04, &
&    1.143434644007808D-05,  -7.118494632384943D-07,   2.982620997358153D-08, &
&   -7.560059068729998D-10,   8.770680079949993D-12,                          &
&    7.104357656949757D-02,  -5.721722705468653D-02,   2.236064370529768D-02, &
&   -5.522298044710004D-03,   9.446329399157067D-04,  -1.158680222609404D-04, &
&    1.023858525073961D-05,  -6.392789051766469D-07,   2.684504108830395D-08, &
&   -6.816048639494272D-10,   7.918094778413129D-12,                          &
&    6.124028426191615D-02,  -5.009575139620643D-02,   1.979709684029426D-02, &
&   -4.928759370416087D-03,   8.480664989881797D-04,  -1.044726019797859D-04, &
&    9.261220112526167D-06,  -5.796463518872227D-07,   2.438559001888241D-08, &
&   -6.200382586061489D-10,   7.210929812988592D-12,                          &
&    5.378682691891385D-02,  -4.452515603406954D-02,   1.774992265121334D-02, &
&   -4.447575699484552D-03,   7.689137234726722D-04,  -9.505658309646160D-05, &
&    8.448818874179021D-06,  -5.298593954209607D-07,   2.232535084397664D-08, &
&   -5.683332087389952D-10,   6.615856209570685D-12,                          &
&    9.780576943491081D-01,  -3.019612506895378D-01,   7.911925486617824D-02, &
&   -1.519414701575452D-02,   2.149664224657751D-03,  -2.247084145104930D-04, &
&    1.718827781251805D-05,  -9.369586467358227D-07,   3.451504891735821D-08, &
&   -7.708721216655729D-10,   7.889882146468255D-12,                          &
&    3.145417101156606D-01,  -1.730613205735080D-01,   5.344025615808368D-02, &
&   -1.106670678996931D-02,   1.632169839039892D-03,  -1.749941153408352D-04, &
&    1.360873076759771D-05,  -7.502909476749230D-07,   2.786320748817665D-08, &
&   -6.260310132334456D-10,   6.436488658902355D-12,                          &
&    1.836108050764510D-01,  -1.193103302702632D-01,   3.978936258122885D-02, &
&   -8.598282449889688D-03,   1.301483956415081D-03,  -1.419147473790913D-04, &
&    1.116386594860672D-05,  -6.205232328174389D-07,   2.318129852431644D-08, &
&   -5.231635922290824D-10,   5.397322747312963D-12,                          &
&    1.283514777341871D-01,  -9.023135026474032D-02,   3.144196593563584D-02, &
&   -6.979627230251610D-03,   1.075103896973240D-03,  -1.186291460214898D-04, &
&    9.410203670882872D-06,  -5.262152523913117D-07,   1.974654419381741D-08, &
&   -4.471705431322418D-10,   4.625581205608747D-12,                          &
&    9.811671370520105D-02,  -7.217476032203520D-02,   2.586408702856775D-02, &
&   -5.847361505857350D-03,   9.119469111525564D-04,  -1.015047723102862D-04, &
&    8.102339283344153D-06,  -4.551734591567836D-07,   1.714011194497856D-08, &
&   -3.891857709711299D-10,   4.034231617048537D-12,                          &
&    7.915110849563987D-02,  -5.994796113689126D-02,   2.189951194697614D-02, &
&   -5.016400600139492D-03,   7.895732303433463D-04,  -8.846487924973135D-05, &
&    7.095632506097183D-06,  -4.000597186606080D-07,   1.510623567081089D-08, &
&   -3.437377991527179D-10,   3.569145120166116D-12,                          &
&    6.619352568437640D-02,  -5.115777075278093D-02,   1.895017709362678D-02, &
&   -4.383539292548408D-03,   6.948280411620336D-04,  -7.825009276343912D-05, &
&    6.300305998167514D-06,  -3.562444648772998D-07,   1.348166257116375D-08, &
&   -3.073043162400108D-10,   3.195252431265062D-12,                          &
&    5.680478940801960D-02,  -4.455386954508288D-02,   1.667773822906811D-02, &
&   -3.887134923159522D-03,   6.195548673511360D-04,  -7.005900093575928D-05, &
&    5.658176547520463D-06,  -3.206879983014061D-07,   1.215818314762462D-08, &
&   -2.775341484430446D-10,   2.889019568167181D-12,                          &
&    4.970275925854344D-02,  -3.942207616845341D-02,   1.487739162023598D-02, &
&   -3.488318786681480D-03,   5.584600915847104D-04,  -6.336072410453833D-05, &
&    5.130133150752611D-06,  -2.913252128400841D-07,   1.106170499728573D-08, &
&   -2.528079432966021D-10,   2.634164802319607D-12,                          &
&    9.633837656245201D-01,  -2.856608489540520D-01,   7.096390473419541D-02, &
&   -1.277410035059276D-02,   1.677976075040404D-03,  -1.616112579401460D-04, &
&    1.132174380556924D-05,  -5.626114414078411D-07,   1.882541146998303D-08, &
&   -3.808574896222144D-10,   3.523398633950644D-12,                          &
&    3.023604661595502D-01,  -1.595274430162099D-01,   4.666781268231422D-02, &
&   -9.056663518938208D-03,   1.240323793732929D-03,  -1.225678432490883D-04, &
&    8.733454623485202D-06,  -4.391405801738451D-07,   1.481994333921109D-08, &
&   -3.017426148029394D-10,   2.805216095280474D-12,                          &
&    1.732570907601090D-01,  -1.078052063967883D-01,   3.403126435424856D-02, &
&   -6.889039741060462D-03,   9.682276391572797D-04,  -9.732075476564597D-05, &
&    7.016323468319262D-06,  -3.557793767000020D-07,   1.208174677252065D-08, &
&   -2.471606595650795D-10,   2.306288976178970D-12,                          &
&    1.193827878695309D-01,  -8.026404934023602D-02,   2.645290438932170D-02, &
&   -5.498483987715341D-03,   7.862852726493092D-04,  -7.997674114263716D-05, &
&    5.814828812707831D-06,  -2.966891165337418D-07,   1.012235167702646D-08, &
&   -2.078253066575163D-10,   1.944767490780308D-12,                          &
&    9.022706483442742D-02,  -6.340574224902356D-02,   2.147436477419927D-02, &
&   -4.544014576100791D-03,   6.577718677203947D-04,  -6.748519881062436D-05, &
&    4.937577733941034D-06,  -2.531167767824930D-07,   8.666874777741023D-09, &
&   -1.784425964726836D-10,   1.673543221400283D-12,                          &
&    7.212185462753505D-02,  -5.213455635102875D-02,   1.798782352640773D-02, &
&   -3.854884863641981D-03,   5.630379869561591D-04,  -5.814206904373612D-05, &
&    4.274528169469180D-06,  -2.199285944972982D-07,   7.551799429604964D-09, &
&   -1.558307390371404D-10,   1.464083502630301D-12,                          &
&    5.986397112354949D-02,  -4.412159785574111D-02,   1.542733862950799D-02, &
&   -3.337408785135321D-03,   4.907817065465596D-04,  -5.093550586274431D-05, &
&    3.758886344441060D-06,  -1.939596514534738D-07,   6.675177944068604D-09, &
&   -1.379893467749196D-10,   1.298335770489927D-12,                          &
&    5.105392633607697D-02,  -3.816058326379044D-02,   1.347657235063080D-02, &
&   -2.936466403642867D-03,   4.341164120916592D-04,  -4.523376844828677D-05, &
&    3.348226176341361D-06,  -1.731745610271316D-07,   5.970845243479291D-09, &
&   -1.236111968497863D-10,   1.164440535938721D-12,                          &
&    4.443752202862695D-02,  -3.356833965963549D-02,   1.194621948340595D-02, &
&   -2.617783500963651D-03,   3.886430956376229D-04,  -4.062552826748371D-05, &
&    3.014540974271816D-06,  -1.562160849534691D-07,   5.394347670493136D-09, &
&   -1.118129735380079D-10,   1.054348441841382D-12,                          &
&    9.448777948218221D-01,  -2.671484514049731D-01,   6.262451802355890D-02, &
&   -1.054633139568289D-02,   1.287149809736457D-03,  -1.145624859724480D-04, &
&    7.385724124618149D-06,  -3.366599884358085D-07,   1.030723776565669D-08, &
&   -1.904270669757638D-10,   1.606325309181194D-12,                          &
&    2.873174809329503D-01,  -1.444764308241063D-01,   3.988643242250410D-02, &
&   -7.244760045708376D-03,   9.223952820914569D-04,  -8.428760175900356D-05, &
&    5.530402414169556D-06,  -2.552320248541870D-07,   7.885479220426910D-09, &
&   -1.466890097113932D-10,   1.244000732172476D-12,                          &
&    1.606891285538728D-01,  -9.522861768820853D-02,   2.836389393209383D-02, &
&   -5.374555077957463D-03,   7.024456649393209D-04,  -6.531435865557090D-05, &
&    4.337821581565541D-06,  -2.019655381459694D-07,   6.281164848342506D-09, &
&   -1.174411520025692D-10,   9.999661235483728D-13,                          &
&    1.086498984149032D-01,  -6.952243688056529D-02,   2.161181532419205D-02, &
&   -4.204642206402272D-03,   5.591960393537346D-04,  -5.262642302074124D-05, &
&    3.525690941145601D-06,  -1.652182454663895D-07,   5.163746522609704D-09, &
&   -9.692142867115284D-11,   8.277884075792188D-13,                          &
&    8.089703744163590D-02,  -5.406714825761661D-02,   1.726515227830437D-02, &
&   -3.418931274453396D-03,   4.602815991422609D-04,  -4.369724637773483D-05, &
&    2.946391040101396D-06,  -1.387460956018866D-07,   4.352781089037319D-09, &
&   -8.194392066287887D-11,   7.015485221343527D-13,                          &
&    6.389221443325591D-02,  -4.389662906397893D-02,   1.427438834501803D-02, &
&   -2.862230218879177D-03,   3.887780180810273D-04,  -3.715038337710367D-05, &
&    2.517250428654928D-06,  -1.189844522042238D-07,   3.743827369679023D-09, &
&   -7.064575551506042D-11,   6.059738168343883D-13,                          &
&    5.251648292162934D-02,  -3.676615632176789D-02,   1.211145418708526D-02, &
&   -2.450958399059242D-03,   3.351541360622871D-04,  -3.218690883092912D-05, &
&    2.189267174251095D-06,  -1.037885708134521D-07,   3.273352852136335D-09, &
&   -6.188435831326187D-11,   5.316374915804456D-13,                          &
&    4.442693438862454D-02,  -3.152598911792664D-02,   1.048545764464393D-02, &
&   -2.136786552866701D-03,   2.937134598409943D-04,  -2.831820866383926D-05, &
&    1.931976970898993D-06,  -9.180905952836628D-08,   2.901028207794980D-09, &
&   -5.492951438715123D-11,   4.724831293132145D-13,                          &
&    3.840851096768458D-02,  -2.753207525083883D-02,   9.224701450072957D-03, &
&   -1.890140209082208D-03,   2.608807742645152D-04,  -2.523204046463189D-05, &
&    1.725655463335212D-06,  -8.216373392773556D-08,   2.600293794088957D-09, &
&   -4.929760700819446D-11,   4.244818079013404D-13,                          &
&    9.233731970930184D-01,  -2.475851473131296D-01,   5.461105231514078D-02, &
&   -8.600032348020172D-03,   9.767491540656274D-04,  -8.059738094819629D-05, &
&    4.803260870008815D-06,  -2.019403466985942D-07,   5.692487732911090D-09, &
&   -9.669862417838185D-11,   7.491785075220797D-13,                          &
&    2.702496400673546D-01,  -1.289463827541278D-01,   3.352383687085994D-02, &
&   -5.699125613988173D-03,   6.758464258405395D-04,  -5.730422649617006D-05, &
&    3.478389243150878D-06,  -1.481641309372003D-07,   4.217233077950094D-09, &
&   -7.217066962793383D-11,   5.624033167816314D-13,                          &
&    1.467062104791421D-01,  -8.250353756567227D-02,   2.314965975809488D-02, &
&   -4.107686918884029D-03,   5.003318825580979D-04,  -4.319068049142403D-05, &
&    2.655112301955238D-06,  -1.141531470379538D-07,   3.272164301494833D-09, &
&   -5.630560142913647D-11,   4.406916448067578D-13,                          &
&    9.690051264516716D-02,  -5.882857627258532D-02,   1.722932313380957D-02, &
&   -3.139718238985679D-03,   3.892779718412508D-04,  -3.402452518412417D-05, &
&    2.110662721974676D-06,  -9.136532845686274D-08,   2.632760986219761D-09, &
&   -4.549143935358383D-11,   3.572420245703604D-13,                          &
&    7.082032372714547D-02,  -4.489469586976356D-02,   1.350574595778539D-02, &
&   -2.505315001183073D-03,   3.144902366855323D-04,  -2.773491360710083D-05, &
&    1.732021399464386D-06,  -7.535913395437938D-08,   2.180239117405306D-09, &
&   -3.779288550906386D-11,   2.975567512473281D-13,                          &
&    5.510425551754733D-02,  -3.589655145279923D-02,   1.099519053420350D-02, &
&   -2.065242308805691D-03,   2.615862009264819D-04,  -2.322320660314894D-05, &
&    1.457614130928385D-06,  -6.366920288546795D-08,   1.847768079290672D-09, &
&   -3.211006163472171D-11,   2.533325826282784D-13,                          &
&    4.474568206061953D-02,  -2.969149698031301D-02,   9.211357372998059D-03, &
&   -1.746054175453177D-03,   2.226493567251967D-04,  -1.986697986168178D-05, &
&    1.251845207794286D-06,  -5.484944599732225D-08,   1.595723259353210D-09, &
&   -2.778548901461196D-11,   2.195744885027311D-13,                          &
&    3.747560825832568D-02,  -2.519697468219965D-02,   7.890849974444343D-03, &
&   -1.506093689117344D-03,   1.930464170822511D-04,  -1.729385886219869D-05, &
&    1.093080756642932D-06,  -4.801073503045585D-08,   1.399527964583509D-09, &
&   -2.440862704956720D-11,   1.931470019555096D-13,                          &
&    3.212917144531268D-02,  -2.181456350936770D-02,   6.880648950787248D-03, &
&   -1.320319575589664D-03,   1.699246132069227D-04,  -1.527059704428271D-05, &
&    9.675984009669316D-07,  -4.258376794297126D-08,   1.243332550715417D-09, &
&   -2.171323173824824D-11,   1.720076750761173D-13,                          &
&    8.999014751973606D-01,  -2.280078001958046D-01,   4.725932586395734D-02, &
&   -6.963234435892309D-03,   7.374815790088290D-04,  -5.660191745151036D-05, &
&    3.131305608325303D-06,  -1.220167003684605D-07,   3.184033221447050D-09, &
&   -5.002158840682138D-11,   3.581382851899454D-13,                          &
&    2.521159279027366D-01,  -1.138183877074746D-01,   2.784181881394745D-02, &
&   -4.433824228879892D-03,   4.908478978625736D-04,  -3.874760689300119D-05, &
&    2.185148416166981D-06,  -8.633192323863729D-08,   2.276213018658568D-09, &
&   -3.604541168844510D-11,   2.597032445207389D-13,                          &
&    1.321762926030154D-01,  -7.038001869269615D-02,   1.859536886248543D-02, &
&   -3.093348465625533D-03,   3.520022947359178D-04,  -2.830979392822835D-05, &
&    1.617871634197083D-06,  -6.455279164193163D-08,   1.714873798686362D-09, &
&   -2.731750019200863D-11,   1.977566278997922D-13,                          &
&    8.491379144350161D-02,  -4.882570482989343D-02,   1.347116139238427D-02, &
&   -2.302581868231580D-03,   2.668446574618299D-04,  -2.173998368333413D-05, &
&    1.254280180027705D-06,  -5.040806461091852D-08,   1.346665015896306D-09, &
&   -2.154831695794019D-11,   1.565601951436745D-13,                          &
&    6.069619816388498D-02,  -3.644520075378764D-02,   1.033084305223638D-02, &
&   -1.798020921009539D-03,   2.110350812699701D-04,  -1.735341485526647D-05, &
&    1.008223524112857D-06,  -4.073901006744376D-08,   1.093015196173056D-09, &
&   -1.754992289480197D-11,   1.278697011016397D-13,                          &
&    4.638761098816521D-02,  -2.862103825763543D-02,   8.261153831910604D-03, &
&   -1.456105472870653D-03,   1.724800208459659D-04,  -1.428075771772976D-05, &
&    8.340885422046715D-07,  -3.384244976029924D-08,   9.109903933106270D-10, &
&   -1.466664505651063D-11,   1.070994239193890D-13,                          &
&    3.712120439870860D-02,  -2.332707324368745D-02,   6.819504573505447D-03, &
&   -1.213112648039616D-03,   1.446830379741722D-04,  -1.204187687051321D-05, &
&    7.061851864007661D-07,  -2.874539339771036D-08,   7.758014929145794D-10, &
&   -1.251682101797981D-11,   9.156299676752657D-14,                          &
&    3.071803591776764D-02,  -1.955580412299523D-02,   5.770663334981300D-03, &
&   -1.033651523233863D-03,   1.239261374010368D-04,  -1.035612251738743D-05, &
&    6.092661013022391D-07,  -2.486378156635525D-08,   6.724396211608748D-10, &
&   -1.086781816809004D-11,   7.961431573262230D-14,                          &
&    2.607322516527528D-02,  -1.675881017009630D-02,   4.980375748575098D-03, &
&   -8.968561989482367D-04,   1.079665436945771D-04,  -9.051386152083337D-06, &
&    5.338663535445686D-07,  -2.183170800144984D-08,   5.914350678266201D-10, &
&   -9.572039733166536D-12,   7.020432647580512D-14,                          &
&    8.754736294065545D-01,  -2.091983841232435D-01,   4.073913417605587D-02, &
&   -5.623298908276029D-03,   5.566980843448528D-04,  -3.986950756656496D-05, &
&    2.055393325467921D-06,  -7.455765954077541D-08,   1.809642726476863D-09, &
&   -2.642569296062858D-11,   1.757683550812112D-13,                          &
&    2.338032286359110D-01,  -9.971477425407583D-02,   2.295188155911166D-02, &
&   -3.428711987057827D-03,   3.552112584921039D-04,  -2.619123657117387D-05, &
&    1.377598070822470D-06,  -5.070334340475105D-08,   1.244221437734476D-09, &
&   -1.832439946215278D-11,   1.227126055537968D-13,                          &
&    1.178648816766673D-01,  -5.935615770814906D-02,   1.477258449643640D-02, &
&   -2.307454132685392D-03,   2.459305900000820D-04,  -1.848871079179083D-05, &
&    9.861330673639868D-07,  -3.667627315030259D-08,   9.072890658767632D-10, &
&   -1.344764138572843D-11,   9.051939944971340D-14,                          &
&    7.334974030197719D-02,  -3.991684169579470D-02,   1.038136895960744D-02, &
&   -1.667288228119258D-03,   1.810874537617411D-04,  -1.379869484287070D-05, &
&    7.433879083586295D-07,  -2.786097071315117D-08,   6.933841113295885D-10, &
&   -1.032701055978108D-11,   6.978888798333898D-14,                          &
&    5.109659207341287D-02,  -2.904886459284119D-02,   7.765328130936969D-03, &
&   -1.270462521542481D-03,   1.398125638707997D-04,  -1.075729975916736D-05, &
&    5.838220238229723D-07,  -2.200683156659080D-08,   5.502055229361497D-10, &
&   -8.225098280886410D-12,   5.575517781322055D-14,                          &
&    3.824162699821850D-02,  -2.234407593744076D-02,   6.083694215309191D-03, &
&   -1.008300709472498D-03,   1.120186509668961D-04,  -8.680716129431321D-06, &
&    4.737405171714881D-07,  -1.793591599333786D-08,   4.500161419401225D-10, &
&   -6.746897112043593D-12,   4.584537876925673D-14,                          &
&    3.008264221804714D-02,  -1.790299446119248D-02,   4.937751678839738D-03, &
&   -8.260893264024918D-04,   9.242389786195134D-05,  -7.201142367604985D-06, &
&    3.946710516782978D-07,  -1.499336986435293D-08,   3.772329751478031D-10, &
&   -5.668679006498437D-12,   3.859286748434380D-14,                          &
&    2.454440699262935D-02,  -1.479792724221642D-02,   4.119916788002912D-03, &
&   -6.941158030923439D-04,   7.807595787694408D-05,  -6.108749618750975D-06, &
&    3.359173374378181D-07,  -1.279576053273235D-08,   3.226536508506798D-10, &
&   -4.857438208258398D-12,   3.312107762961370D-14,                          &
&    2.058973760187303D-02,  -1.253255466140719D-02,   3.513987014292393D-03, &
&   -5.952221952959501D-04,   6.723208896587614D-05,  -5.277687566979978D-06, &
&    2.909874576693652D-07,  -1.110825987355378D-08,   2.806025953086317D-10, &
&   -4.230685519984805D-12,   2.888392412294276D-14,                          &
&    8.509405453338657D-01,  -1.916566496223360D-01,   3.509285087350959D-02, &
&   -4.545925836793842D-03,   4.217409769224744D-04,  -2.827305478262504D-05, &
&    1.363166817993445D-06,  -4.621307243689643D-08,   1.047710364927383D-09, &
&   -1.428416618196039D-11,   8.867273614355398D-14,                          &
&    2.160125958589565D-01,  -8.699143220514850D-02,   1.885568590413206D-02, &
&   -2.646952080205356D-03,   2.572640339585543D-04,  -1.777320726746558D-05, &
&    8.749984610758922D-07,  -3.011921795367511D-08,   6.907862905082136D-10, &
&   -9.503532420513975D-12,   5.942458332765692D-14,                          &
&    1.043431511035230D-01,  -4.968413172954565D-02,   1.165819991555788D-02, &
&   -1.712970192290355D-03,   1.714344271515626D-04,  -1.208506868624361D-05, &
&    6.037370244978956D-07,  -2.101244085580878D-08,   4.860715667679314D-10, &
&   -6.732971369736396D-12,   4.233479658633114D-14,                          &
&    6.267508166779108D-02,  -3.228019979946045D-02,   7.922018663319321D-03, &
&   -1.197771196248422D-03,   1.222426576904143D-04,  -8.739703060874451D-06, &
&    4.412446739583450D-07,  -1.548270392667939D-08,   3.604714704878620D-10, &
&   -5.019262148318772D-12,   3.169499212244867D-14,                          &
&    4.240617229808827D-02,  -2.283098594466327D-02,   5.762640604397821D-03, &
&   -8.880808751644418D-04,   9.188266520340136D-05,  -6.636181932690618D-06, &
&    3.376626591345539D-07,  -1.192091075678240D-08,   2.789128911687054D-10, &
&   -3.899264922711292D-12,   2.470484126154390D-14,                          &
&    3.098675335603597D-02,  -1.715277811591021D-02,   4.411481836171963D-03, &
&   -6.889854090052989D-04,   7.198976182359574D-05,  -5.238594108367871D-06, &
&    2.681175416146809D-07,  -9.510047036099175D-09,   2.233530462704913D-10, &
&   -3.132331987733704D-12,   1.989786254870538D-14,                          &
&    2.389995046507418D-02,  -1.347852367109744D-02,   3.512425025173707D-03, &
&   -5.538942867965890D-04,   5.829899513472916D-05,  -4.266457754947425D-06, &
&    2.193460038662402D-07,  -7.808415296263442D-09,   1.839351492598214D-10, &
&   -2.585925177269916D-12,   1.646115515772264D-14,                          &
&    1.918463281443940D-02,  -1.096207228642300D-02,   2.884119767181385D-03, &
&   -4.580979987424434D-04,   4.848440769701242D-05,  -3.563740386486249D-06, &
&    1.838613913933547D-07,  -6.563941276675245D-09,   1.549860986155088D-10, &
&   -2.183249998096743D-12,   1.392117474825428D-14,                          &
&    1.587654285327304D-02,  -9.159228428263372D-03,   2.427134697142679D-03, &
&   -3.876375052120232D-04,   4.120381573563234D-05,  -3.038997361937623D-06, &
&    1.572247848455093D-07,  -5.625829094497942D-09,   1.330883434209457D-10, &
&   -1.877785712345960D-12,   1.198975449749115D-14,                          &
&    8.269350959152356D-01,  -1.756366178748471D-01,   3.028039952199573D-02, &
&   -3.688962262447488D-03,   3.215648338707494D-04,  -2.024064602076067D-05, &
&    9.157618295761364D-07,  -2.911942845605330D-08,   6.189911539611490D-10, &
&   -7.910313010957717D-12,   4.601697724500259D-14,                          &
&    1.992227281074196D-01,  -7.578439215577396D-02,   1.548836929357271D-02, &
&   -2.047202568522340D-03,   1.871408480930694D-04,  -1.214937010940459D-05, &
&    5.616863855916193D-07,  -1.814629810368495D-08,   3.904366129323353D-10, &
&   -5.037264805093956D-12,   2.952890287557844D-14,                          &
&    9.196768378616786D-02,  -4.142218694398424D-02,   9.175339696891474D-03, &
&   -1.270672106022160D-03,   1.197114531146846D-04,  -7.936186545016342D-06, &
&    3.725562091046676D-07,  -1.217654105932418D-08,   2.643777164454725D-10, &
&   -3.435760859690322D-12,   2.026057029881963D-14,                          &
&    5.315496213555760D-02,  -2.592354842059953D-02,   6.011445795675814D-03, &
&   -8.573696565119016D-04,   8.242965579540573D-05,  -5.545685155553255D-06, &
&    2.632435861685553D-07,  -8.678363397979004D-09,   1.897244846518345D-10, &
&   -2.479401208982198D-12,   1.468859510585309D-14,                          &
&    3.482269818389616D-02,  -1.776680326325112D-02,   4.240342666313816D-03, &
&   -6.168228792907150D-04,   6.015261133986486D-05,  -4.090301921286517D-06, &
&    1.957641717908008D-07,  -6.495964058780110D-09,   1.427632235607591D-10, &
&   -1.873787817374463D-12,   1.114098100304771D-14,                          &
&    2.477108275053096D-02,  -1.300155844816362D-02,   3.163487812307452D-03, &
&   -4.665818177793947D-04,   4.597161610691458D-05,  -3.150790644039227D-06, &
&    1.517383211893456D-07,  -5.060262586423288D-09,   1.116652528474381D-10, &
&   -1.470596563121121D-12,   8.768686061186612D-15,                          &
&    1.868436990721014D-02,  -9.994911881843434D-03,   2.465041244128162D-03, &
&   -3.672243621672272D-04,   3.645922747786534D-05,  -2.513787231494300D-06, &
&    1.216391625585381D-07,  -4.072240275145017D-09,   9.015034210402148D-11, &
&   -1.190434263087034D-12,   7.114282605970098D-15,                          &
&    1.472234948959332D-02,  -7.981376446781079D-03,   1.987873996348111D-03, &
&   -2.983523944536639D-04,   2.979326824780876D-05,  -2.063637172589467D-06, &
&    1.002281732194298D-07,  -3.365680357369524D-09,   7.469787191829718D-11, &
&   -9.884948043899642D-13,   5.918215602324302D-15,                          &
&    1.199637934141504D-02,  -6.567204217411570D-03,   1.647704972887901D-03, &
&   -2.487039508063918D-04,   2.494674430433078D-05,  -1.734161475014141D-06, &
&    8.447333194208677D-08,  -2.843524008958336D-09,   6.323767070387121D-11, &
&   -8.382835791950977D-13,   5.026301655707588D-15,                          &
&    8.038741406491371D-01,  -1.612092627469368D-01,   2.621756631450637D-02, &
&   -3.010778008355478D-03,   2.472533760677464D-04,  -1.465559825536382D-05, &
&    6.241836159954865D-07,  -1.867834226970064D-08,   3.735629552206814D-10, &
&   -4.490692776773598D-12,   2.457021456039873D-14,                          &
&    1.837065721492889D-01,  -6.607519376854618D-02,   1.275363341817471D-02, &
&   -1.590615366659420D-03,   1.371003860157726D-04,  -8.387690989341325D-06, &
&    3.652603543590219D-07,  -1.111106445263025D-08,   2.250326530009781D-10, &
&   -2.732176275772962D-12,   1.506919815518907D-14,                          &
&    8.090669670965682D-02,  -3.449955643733217D-02,   7.225130895435082D-03, &
&   -9.450099495316116D-04,   8.401356152557620D-05,  -5.252198825202823D-06, &
&    2.323797318809909D-07,  -7.155061302931334D-09,   1.462978306057753D-10, &
&   -1.789895994264411D-12,   9.934330268587791D-15,                          &
&    4.488512793864232D-02,  -2.074699050381994D-02,   4.552907083196118D-03, &
&   -6.137732065312955D-04,   5.572340631204002D-05,  -3.537437021063414D-06, &
&    1.583429037347473D-07,  -4.919980707080125D-09,   1.013328672021340D-10, &
&   -1.247162231676002D-12,   6.956301992042713D-15,                          &
&    2.839257346664598D-02,  -1.374129435447563D-02,   3.105972718165213D-03, &
&   -4.273423284906560D-04,   3.937654183944485D-05,  -2.527785772506633D-06, &
&    1.141356485717668D-07,  -3.570997420896225D-09,   7.396343919114793D-11, &
&   -9.145489159577625D-13,   5.120991400688156D-15,                          &
&    1.960757264082766D-02,  -9.768638446566447D-03,   2.252364139300254D-03, &
&   -3.143744725839953D-04,   2.928060676673133D-05,  -1.895362591380293D-06, &
&    8.614536499861651D-08,  -2.709634280026012D-09,   5.636874395621110D-11, &
&   -6.995425445890263D-13,   3.929181247984518D-15,                          &
&    1.442620060397615D-02,  -7.328581048405123D-03,   1.713526477525619D-03, &
&   -2.416685500497532D-04,   2.268951953052653D-05,  -1.477989975080995D-06, &
&    6.751629537030273D-08,  -2.132479978155967D-09,   4.451491014989427D-11, &
&   -5.540353553692873D-13,   3.119570175183327D-15,                          &
&    1.113251388863181D-02,  -5.733353703499701D-03,   1.354209828924332D-03, &
&   -1.924774152201243D-04,   1.818102728221009D-05,  -1.190061050812532D-06, &
&    5.457811211972551D-08,  -1.729455178197045D-09,   3.620046609804465D-11, &
&   -4.515954734254265D-13,   2.547804106175402D-15,                          &
&    8.913862143964646D-03,  -4.636741004217617D-03,   1.103515919449010D-03, &
&   -1.577725789622573D-04,   1.497281890640359D-05,  -9.837829280725948D-07, &
&    4.525848787525386D-08,  -1.437859884834980D-09,   3.016272126862733D-11, &
&   -3.769769611936494D-13,   2.130234006526601D-15,                          &
&    7.819934100469579D-01,  -1.483261748745041D-01,   2.280330148446545D-02, &
&   -2.474441779052362D-03,   1.919498632714129D-04,  -1.074432953767410D-05, &
&    4.320399685135714D-07,  -1.220418463079376D-08,   2.303721329401353D-10, &
&   -2.613502381507587D-12,   1.349330533811398D-14,                          &
&    1.695743020228841D-01,  -5.775260340242632D-02,   1.054753883312958D-02, &
&   -1.243996389813817D-03,   1.013520303601306D-04,  -5.858922915276280D-06, &
&    2.410078411197646D-07,  -6.923610834048567D-09,   1.323988988486779D-10, &
&   -1.517530982241229D-12,   7.900397453500484D-15,                          &
&    7.118696886447687D-02,  -2.877451150445554D-02,   5.707302632636808D-03, &
&   -7.064877182786616D-04,   5.940929147693962D-05,  -3.511429829404501D-06, &
&    1.468307457000165D-07,  -4.271447969793911D-09,   8.249596584879663D-11, &
&   -9.531562318654088D-13,   4.995046444206219D-15,                          &
&    3.784003713710565D-02,  -1.659668976855112D-02,   3.452403665129198D-03, &
&   -4.408052685654572D-04,   3.787846671027844D-05,  -2.274698474289286D-06, &
&    9.627677151855515D-08,  -2.827583365507596D-09,   5.503002994195357D-11, &
&   -6.398227824624062D-13,   3.370620971028122D-15,                          &
&    2.305851902137518D-02,  -1.059854901956288D-02,   2.272522416833962D-03, &
&   -2.963298977690469D-04,   2.585829295772084D-05,  -1.571082833868282D-06, &
&    6.710548361697370D-08,  -1.985286762213742D-09,   3.886844679149054D-11, &
&   -4.541581741080918D-13,   2.402524533089967D-15,                          &
&    1.542033681602295D-02,  -7.301295401031730D-03,   1.597953516781385D-03, &
&   -2.114939112128675D-04,   1.866386309663042D-05,  -1.143916305127776D-06, &
&    4.920109175379284D-08,  -1.463846127255824D-09,   2.879378674656455D-11, &
&   -3.377617389111531D-13,   1.792734776998369D-15,                          &
&    1.103922199384014D-02,  -5.332594548126783D-03,   1.184080858084854D-03, &
&   -1.584256487239495D-04,   1.409843536179468D-05,  -8.698588617433510D-07, &
&    3.761507500397296D-08,  -1.124090421107796D-09,   2.219249476832880D-11, &
&   -2.611390593038777D-13,   1.389745031562913D-15,                          &
&    8.323748407160415D-03,  -4.077975248631716D-03,   9.150752226208380D-04, &
&   -1.234279949319112D-04,   1.105418360371316D-05,  -6.855359151460558D-07, &
&    2.976902947950731D-08,  -8.927235033447958D-10,   1.767645670470236D-11, &
&   -2.085186954173652D-13,   1.112091819004279D-15,                          &
&    6.535705224723656D-03,  -3.235045400892375D-03,   7.316508395091938D-04, &
&   -9.929639552146816D-05,   8.936844620692365D-06,  -5.564522947096570D-07, &
&    2.424380257732239D-08,  -7.290508472238710D-10,   1.446962075417378D-11, &
&   -1.710335851053029D-13,   9.137617090813088D-16,                          &
&    7.613935473100934D-01,  -1.368717586305058D-01,   1.993655587350417D-02, &
&   -2.049179820149247D-03,   1.505414985233760D-04,  -7.978932319554038D-06, &
&    3.037599581323493D-07,  -8.122890012159733D-09,   1.451406057066273D-10, &
&   -1.558502097125426D-12,   7.615558934351046D-15,                          &
&    1.568223822126302D-01,  -5.066057860770576D-02,   8.772236112930380D-03, &
&   -9.805903742471107D-04,   7.569874382184696D-05,  -4.145367742255391D-06, &
&    1.615045640361383D-07,  -4.393676364098400D-09,   7.955477998978025D-11, &
&   -8.632959599451165D-13,   4.254733693732506D-15,                          &
&    6.274286024945071D-02,  -2.407745276052712D-02,   4.531307297963450D-03, &
&   -5.319713347605603D-04,   4.241000313153512D-05,  -2.375731759548999D-06, &
&    9.412879102865543D-08,  -2.594082610407692D-09,   4.745375103557507D-11, &
&   -5.192409685962598D-13,   2.576670912939908D-15,                          &
&    3.192012289080974D-02,  -1.330320031191842D-02,   2.627687545193972D-03, &
&   -3.183990209819691D-04,   2.595324418025788D-05,  -1.477866293202322D-06, &
&    5.929405901967208D-08,  -1.650336392060078D-09,   3.043206779701456D-11, &
&   -3.351876757675571D-13,   1.672510418213258D-15,                          &
&    1.870422773911497D-02,  -8.175744762642612D-03,   1.665749150034066D-03, &
&   -2.062588236488564D-04,   1.708206428309361D-05,  -9.845830624921923D-07, &
&    3.988103267812615D-08,  -1.118550107955101D-09,   2.075597466520930D-11, &
&   -2.298126734775143D-13,   1.151799160169709D-15,                          &
&    1.208638068960535D-02,  -5.446001600139057D-03,   1.133253503377303D-03, &
&   -1.425043517205050D-04,   1.194094793431330D-05,  -6.945825054382856D-07, &
&    2.834121360141304D-08,  -7.996581076123043D-10,   1.491240598853301D-11, &
&   -1.658034268265714D-13,   8.339559410868307D-16,                          &
&    8.399465617001103D-03,  -3.863460541448196D-03,   8.160653861713210D-04, &
&   -1.037843078331971D-04,   8.773184302283554D-06,  -5.139031977048781D-07, &
&    2.108850149259429D-08,  -5.978233707776275D-10,   1.119251865510373D-11, &
&   -1.248609770595811D-13,   6.298303025192273D-16,                          &
&    6.174337671960122D-03,  -2.881633237684822D-03,   6.153672309514981D-04, &
&   -7.892473606427638D-05,   6.716591812523490D-06,  -3.955729603033124D-07, &
&    1.630523950076221D-08,  -4.639494871444037D-10,   8.713492698991719D-12, &
&   -9.746745761683826D-14,   4.927939704193399D-16,                          &
&    4.744087989197121D-03,  -2.237772306227328D-03,   4.817947499076961D-04, &
&   -6.219278073885622D-05,   5.320200341624257D-06,  -3.146656832153447D-07, &
&    1.301613429961762D-08,  -3.714627097343502D-10,   6.994149527897058D-12, &
&   -7.840554559857643D-14,   3.971661760271322D-16,                          &
&    7.420839586504420D-01,  -1.267005311894361D-01,   1.752514330817058D-02, &
&   -1.710326988399691D-03,   1.192875303066348D-04,  -6.001837870048782D-06, &
&    2.168895162665816D-07,  -5.505041459730659D-09,   9.335956277104336D-11, &
&   -9.514338375593363D-13,   4.412235769314547D-15,                          &
&    1.453772225594322D-01,  -4.463075021061571D-02,   7.342401496684674D-03, &
&   -7.796311105358440D-04,   5.715981648508576D-05,  -2.972391393769722D-06, &
&    1.099560528808505D-07,  -2.839963705606653D-09,   4.881654829162258D-11, &
&   -5.028606731792292D-13,   2.352464452019967D-15,                          &
&    5.545757235311412D-02,  -2.023856190143136D-02,   3.620843881399440D-03, &
&   -4.039859098041561D-04,   3.060101280793980D-05,  -1.628435223637431D-06, &
&    6.128182678539888D-08,  -1.603877779662034D-09,   2.786042120549530D-11, &
&   -2.894507745523889D-13,   1.363698946199204D-15,                          &
&    2.698979638114527D-02,  -1.070481732627155D-02,   2.011336328830239D-03, &
&   -2.317438397931737D-04,   1.795646812248053D-05,  -9.717350458028223D-07, &
&    3.704389170775903D-08,  -9.794781255595584D-10,   1.715563236977656D-11, &
&   -1.794577677419972D-13,   8.503465771787153D-16,                          &
&    1.518889385134971D-02,  -6.322833011678723D-03,   1.226166623962491D-03, &
&   -1.444476213734106D-04,   1.137716515826668D-05,  -6.234589944780823D-07, &
&    2.400336654320960D-08,  -6.397611806766782D-10,   1.127933060790732D-11, &
&   -1.186383046487938D-13,   5.647825747798076D-16,                          &
&    9.466805766858007D-03,  -4.065069729315687D-03,   8.056027811098437D-04, &
&   -9.642663019200058D-05,   7.687660248018006D-06,  -4.253136759464028D-07, &
&    1.650074109082663D-08,  -4.425670022462717D-10,   7.843667704735712D-12, &
&   -8.286720935060944D-14,   3.959883771193410D-16,                          &
&    6.373437362755318D-03,  -2.795308195022638D-03,   5.626002272122130D-04, &
&   -6.813556326136898D-05,   5.482213693658355D-06,  -3.055351069701328D-07, &
&    1.192503236983369D-08,  -3.214376914528174D-10,   5.720798576466431D-12, &
&   -6.065558603822538D-14,   2.907408000484106D-16,                          &
&    4.557606283347572D-03,  -2.029190106557792D-03,   4.130698487895446D-04, &
&   -5.046991038046937D-05,   4.089499704781719D-06,  -2.292232631937438D-07, &
&    8.988962873162679D-09,  -2.432582918436611D-10,   4.343985257916528D-12, &
&   -4.619087112993013D-14,   2.219614548047345D-16,                          &
&    3.419704983321391D-03,  -1.539418076063754D-03,   3.160517599438732D-04, &
&   -3.887778659237977D-05,   3.167472796016727D-06,  -1.783423889441393D-07, &
&    7.019986088251980D-09,  -1.905782252032930D-10,   3.412502881885384D-12, &
&   -3.637130821342862D-14,   1.751326574742547D-16,                          &
&    7.240183461563611D-01,  -1.176609201109964D-01,   1.548933778533343D-02, &
&   -1.438585490944341D-03,   9.547959185204665D-05,  -4.571273030415467D-06, &
&    1.571849680615682D-07,  -3.796100960930294D-09,   6.125312867383396D-11, &
&   -5.939227447084999D-13,   2.620494199993903D-15,                          &
&    1.351284943956746D-01,  -3.950159510042340D-02,   6.187057979110606D-03, &
&   -6.253866775249832D-04,   4.364363763980016D-05,  -2.160088156512830D-06, &
&    7.604850160421365D-08,  -1.869243248842294D-09,   3.057602140700893D-11, &
&   -2.997125987030712D-13,   1.334163288640033D-15,                          &
&    4.919319201668579D-02,  -1.710291197900344D-02,   2.914418325466684D-03, &
&   -3.096584321288284D-04,   2.233385918766598D-05,  -1.131507186330105D-06, &
&    4.053532639299820D-08,  -1.009837962481670D-09,   1.669612024904955D-11, &
&   -1.650911329676709D-13,   7.402292035362774D-16,                          &
&    2.290388577178575D-02,  -8.659288021958287D-03,   1.550430862394459D-03, &
&   -1.701906005553854D-04,   1.256091678689460D-05,  -6.473653066718478D-07, &
&    2.349952973933546D-08,  -5.915993841081124D-10,   9.864776602748360D-12, &
&   -9.823219220062013D-14,   4.430648925815132D-16,                          &
&    1.237025937478481D-02,  -4.911542408249366D-03,   9.081254332016869D-04, &
&   -1.019677592298750D-04,   7.653003015072006D-06,  -3.995386638654274D-07, &
&    1.465206520585207D-08,  -3.719247609422693D-10,   6.244183702076425D-12, &
&   -6.253528439236339D-14,   2.834319169169140D-16,                          &
&    7.426713437295747D-03,  -3.043468348327026D-03,   5.753513832704573D-04, &
&   -6.566879267989825D-05,   4.990821533117127D-06,  -2.631425625344005D-07, &
&    9.727360565785950D-09,  -2.485425955202685D-10,   4.195691167712539D-12, &
&   -4.221547084099070D-14,   1.920994551121198D-16,                          &
&    4.835297808657933D-03,  -2.024981650095807D-03,   3.889629097677856D-04, &
&   -4.493791794017978D-05,   3.448029407278672D-06,  -1.831986425311691D-07, &
&    6.814867806411985D-09,  -1.750405395458472D-10,   2.967996361639836D-12, &
&   -2.997605966496835D-14,   1.368511022363401D-16,                          &
&    3.357138769120169D-03,  -1.427918230040330D-03,   2.775258254466875D-04, &
&   -3.235974574666940D-05,   2.501282557068832D-06,  -1.336983847493142D-07, &
&    4.998380134064935D-09,  -1.289244494667263D-10,   2.193889608875551D-12, &
&   -2.222617781066349D-14,   1.017424663547477D-16,                          &
&    2.454935336399734D-03,  -1.056158718272026D-03,   2.071021065369849D-04, &
&   -2.431971316669604D-05,   1.890659684828794D-06,  -1.015408711396263D-07, &
&    3.811313625704940D-09,  -9.863927978738130D-11,   1.683411142483056D-12, &
&   -1.709749948099029D-14,   7.843765672574163D-17,                          &
&    7.071203139866308D-01,  -1.096086524186581D-01,   1.376237649622242D-02, &
&   -1.219066052279567D-03,   7.716478356074469D-05,  -3.523313338443657D-06, &
&    1.155370022493700D-07,  -2.660944850373656D-09,   4.094565269061646D-11, &
&   -3.786041141803230D-13,   1.592977965211113D-15,                          &
&    1.259520758024299D-01,  -3.512808868748288D-02,   5.248915924651515D-03, &
&   -5.061160879685596D-04,   3.369102583309551D-05,  -1.590509797124162D-06, &
&    5.340848185932901D-08,  -1.252062205237141D-09,   1.953302898729938D-11, &
&   -1.826047196685286D-13,   7.752213386972167D-16,                          &
&    4.381015602687357D-02,  -1.453692515054050D-02,   2.363910123672340D-03, &
&   -2.396582743225057D-04,   1.649170390240405D-05,  -7.971121763039887D-07, &
&    2.724140005187109D-08,  -6.473788094443452D-10,   1.020972895165465D-11, &
&   -9.629370545244554D-14,   4.118147031375280D-16,                          &
&    1.952377024916458D-02,  -7.047810652222969D-03,   1.204651517039393D-03, &
&   -1.262162269858021D-04,   8.890300095895408D-06,  -4.372339249372452D-07, &
&    1.514447183045979D-08,  -3.637645107644963D-10,   5.786947182570519D-12, &
&   -5.497456160565364D-14,   2.365376760346663D-16,                          &
&    1.011772444949165D-02,  -3.837492176799289D-03,   6.776313662954604D-04, &
&   -7.265068673201410D-05,   5.205517597420391D-06,  -2.594083738095564D-07, &
&    9.079560150039572D-09,  -2.199466748908401D-10,   3.523679259353232D-12, &
&   -3.367221177304909D-14,   1.456105985732989D-16,                          &
&    5.846142376063920D-03,  -2.289729008205937D-03,   4.135767729058682D-04, &
&   -4.508975101851225D-05,   3.272602632607496D-06,  -1.647541118871016D-07, &
&    5.814303607112953D-09,  -1.418092478430828D-10,   2.284861769009197D-12, &
&   -2.194012864276875D-14,   9.527278063277177D-17,                          &
&    3.675893459622015D-03,  -1.472025679606764D-03,   2.702690854981772D-04, &
&   -2.983742203249955D-05,   2.187094233663489D-06,  -1.109871231240457D-07, &
&    3.942589589888573D-09,  -9.668705614562783D-11,   1.565092877917651D-12, &
&   -1.508856487734560D-14,   6.574680717121583D-17,                          &
&    2.473732172073033D-03,  -1.006552607729401D-03,   1.870693968474108D-04, &
&   -2.085054381147381D-05,   1.540136570827624D-06,  -7.864987339214079D-08, &
&    2.808562282561885D-09,  -6.918213123925531D-11,   1.124111504675662D-12, &
&   -1.087268346630724D-14,   4.751171370354334D-17,                          &
&    1.759681872547449D-03,  -7.245098280295628D-04,   1.358995227619154D-04, &
&   -1.525950179164032D-05,   1.133967573048851D-06,  -5.819855875363787D-08, &
&    2.087020684739582D-09,  -5.159340030924337D-11,   8.409117761882928D-13, &
&   -8.155355242211666D-15,   3.572133200602780D-17,                          &
&    6.913009439438546D-01,  -1.024134346787509D-01,   1.228947122446092D-02, &
&   -1.040365672579131D-03,   6.293465058628011D-05,  -2.746173674962381D-06, &
&    8.605954295047542D-08,  -1.894135383535712D-09,   2.785331105545887D-11, &
&   -2.461192061294954D-13,   9.895980466267946D-16,                          &
&    1.177241639309360D-01,  -3.138513588222208D-02,   4.482587108874285D-03, &
&   -4.131262061156279D-04,   2.628493564028745D-05,  -1.185981549418406D-06, &
&    3.806197722743289D-08,  -8.527832372712063D-10,   1.271473505448430D-11, &
&   -1.135975704895354D-13,   4.608900095423365D-16,                          &
&    3.917822120624335D-02,  -1.242948998862166D-02,   1.932369143563895D-03, &
&   -1.872850225046381D-04,   1.231984392617375D-05,  -5.692058527686169D-07, &
&    1.859403703316549D-08,  -4.223608250260468D-10,   6.366617611632813D-12, &
&   -5.739208938719237D-14,   2.345887253007040D-16,                          &
&    1.672566184710071D-02,  -5.774543839300518D-03,   9.438859248707199D-04, &
&   -9.456425615260172D-05,   6.368655757468011D-06,  -2.994580175993069D-07, &
&    9.916138326824021D-09,  -2.276954500631961D-10,   3.462671949613523D-12, &
&   -3.144387956170126D-14,   1.293224713972292D-16,                          &
&    8.318515044468005D-03,  -3.018658173123461D-03,   5.099109458496459D-04, &
&   -5.228985372992116D-05,   3.583193363761697D-06,  -1.707568837866019D-07, &
&    5.714949119829259D-09,  -1.323697553502366D-10,   2.027524936539708D-12, &
&   -1.852328861256721D-14,   7.657678336482050D-17,                          &
&    4.624079144658190D-03,  -1.733488918942525D-03,   2.996287657549342D-04, &
&   -3.125502315908245D-05,   2.170132271997635D-06,  -1.045024008017305D-07, &
&    3.527271993300147D-09,  -8.227309113339614D-11,   1.267626971603998D-12, &
&   -1.163911143221288D-14,   4.832515883392134D-17,                          &
&    2.805126884022921D-03,  -1.075639463713278D-03,   1.890587839853181D-04, &
&   -1.997637394444722D-05,   1.401194082879733D-06,  -6.803172540056869D-08, &
&    2.311911093691844D-09,  -5.423246275725242D-11,   8.396341682102402D-13, &
&   -7.741411891008431D-15,   3.225798174669104D-17,                          &
&    1.827179731466634D-03,  -7.122028123652638D-04,   1.267579918524822D-04, &
&   -1.352644056145272D-05,   9.563666238252282D-07,  -4.673927131908991D-08, &
&    1.597048401299817D-09,  -3.763735666534350D-11,   5.850255452775882D-13, &
&   -5.412504690462656D-15,   2.262141987859282D-17,                          &
&    1.262382615284010D-03,  -4.980889292208647D-04,   8.950242178632964D-05, &
&   -9.624625460371469D-06,   6.847982459199753D-07,  -3.364346074078981D-08, &
&    1.154682944098000D-09,  -2.731554223438833D-11,   4.259778961826428D-13, &
&   -3.952295776940581D-15,   1.655997144189111D-17,                          &
&    6.764688598217261D-01,  -9.596090653699402D-02,   1.102610768181839D-02, &
&   -8.937632495917478D-04,   5.176906816527075D-05,  -2.162966496161339D-06, &
&    6.490226343328704D-08,  -1.367757209750170D-09,   1.925797166810106D-11, &
&   -1.629347686241178D-13,   6.272789631519087D-16,                          &
&    1.103291586161586D-01,  -2.816753927705972D-02,   3.852507571053875D-03, &
&   -3.399999245287404D-04,   2.071463062613790D-05,  -8.949864720231385D-07, &
&    2.750383002227095D-08,  -5.900646625891631D-10,   8.424107176273401D-12, &
&   -7.206730525938924D-14,   2.799733740445865D-16,                          &
&    3.518174804677678D-02,  -1.069035564656704D-02,   1.591757100861909D-03, &
&   -1.477482558568863D-04,   9.307742382315795D-06,  -4.118296099364973D-07, &
&    1.288314361448028D-08,  -2.802360353429814D-10,   4.045150638686222D-12, &
&   -3.491868607730858D-14,   1.366746802857730D-16,                          &
&    1.440368470505091D-02,  -4.763953488645541D-03,   7.459325397523571D-04, &
&   -7.158346737156193D-05,   4.617623460622353D-06,  -2.079573223758463D-07, &
&    6.595283847017720D-09,  -1.450391275755837D-10,   2.112375639912173D-12, &
&   -1.837026709742450D-14,   7.235436342239774D-17,                          &
&    6.878882564288519D-03,  -2.392006532770854D-03,   3.871468833671772D-04, &
&   -3.803605993116688D-05,   2.496975738904800D-06,  -1.139888115633677D-07, &
&    3.654382945678231D-09,  -8.107538973865341D-11,   1.189456640103017D-12, &
&   -1.040802635766928D-14,   4.121002687069828D-17,                          &
&    3.678484083679343D-03,  -1.321834580599496D-03,   2.189738806436637D-04, &
&   -2.188926910825800D-05,   1.456323458113032D-06,  -6.719268737332873D-08, &
&    2.172840786374985D-09,  -4.855270265195635D-11,   7.166229964435176D-13, &
&   -6.302935050271500D-15,   2.506701670588079D-17,                          &
&    2.151941792325161D-03,  -7.912501605613883D-04,   1.333324309650252D-04, &
&   -1.350462051852943D-05,   9.078950508068298D-07,  -4.224481682994942D-08, &
&    1.375679728656667D-09,  -3.092110760014976D-11,   4.586751653916360D-13, &
&   -4.051618272540469D-15,   1.617394216511785D-17,                          &
&    1.355320627856884D-03,  -5.067409742307810D-04,   8.649367601016223D-05, &
&   -8.849914065730545D-06,   5.998716826189519D-07,  -2.810192874286679D-08, &
&    9.203277744555608D-10,  -2.078598794115703D-11,   3.096107675137061D-13, &
&   -2.744710588623671D-15,   1.099123843942545D-17,                          &
&    9.081890113280914D-04,  -3.438474482618255D-04,   5.927285603398391D-05, &
&   -6.113256470356192D-06,   4.170985742346984D-07,  -1.964695082115501D-08, &
&    6.464224195188917D-10,  -1.465788778169861D-11,   2.190846736921935D-13, &
&   -1.948044449870148D-15,   7.821668876797676D-18,                          &
&    6.625363607013483D-01,  -9.015254615858700D-02,   9.936314621318924D-03, &
&   -7.725795655664945D-04,   4.292469719216188D-05,  -1.720290201234009D-06, &
&    4.951376137272249D-08,  -1.000895142197020D-09,   1.351771001379322D-11, &
&   -1.097031350251801D-13,   4.051151525570948D-16,                          &
&    1.036631166871649D-01,  -2.538812343609786D-02,   3.330946769044433D-03, &
&   -2.819948547259318D-04,   1.648064281776928D-05,  -6.830382821614241D-07, &
&    2.013496641827598D-08,  -4.143663349713689D-10,   5.674586014742388D-12, &
&   -4.656639796775702D-14,   1.735297859166914D-16,                          &
&    3.172110627593678D-02,  -9.247240373994669D-03,   1.320918041288492D-03, &
&   -1.176229737558650D-04,   7.108497776777725D-06,  -3.017232653367641D-07, &
&    9.054527890840707D-09,  -1.889367384682008D-10,   2.616206264391199D-12, &
&   -2.166391484053487D-14,   8.134038992026446D-17,                          &
&    1.246930907683358D-02,  -3.957194129148102D-03,   5.945021416990734D-04, &
&   -5.473766853717680D-05,   3.387658673939616D-06,  -1.463701781876586D-07, &
&    4.453488390409805D-09,  -9.395781542761899D-11,   1.312784032927455D-12, &
&   -1.095232707004799D-14,   4.138277503905556D-17,                          &
&    5.722852448440570D-03,  -1.909807545207418D-03,   2.966259022678017D-04, &
&   -2.796484980503027D-05,   1.761553894120179D-06,  -7.716000480903325D-08, &
&    2.373441634195327D-09,  -5.052147547114303D-11,   7.111278573796708D-13, &
&   -5.969947871219873D-15,   2.267776625797555D-17,                          &
&    2.945109454111709D-03,  -1.015895554358353D-03,   1.615345178569124D-04, &
&   -1.549790282130740D-05,   9.895564293366521D-07,  -4.381493335311639D-08, &
&    1.359643822303081D-09,  -2.915346643372989D-11,   4.128875898621106D-13, &
&   -3.484455567373315D-15,   1.329640194213638D-17,                          &
&    1.660953933966689D-03,  -5.864033837023698D-04,   9.486853890513137D-05, &
&   -9.224197936636463D-06,   5.952565980059245D-07,  -2.658472738436991D-08, &
&    8.308806372215728D-10,  -1.792317256456278D-11,   2.551424718819807D-13, &
&   -2.162746045025586D-15,   8.284692480517035D-18,                          &
&    1.010966424744074D-03,  -3.630572575731754D-04,   5.951160340075674D-05, &
&   -5.846935323387811D-06,   3.805147323336376D-07,  -1.711322420065438D-08, &
&    5.380036231104447D-10,  -1.166351334520564D-11,   1.667492505522551D-13, &
&   -1.418763289972759D-15,   5.452615397321903D-18,                          &
&    6.563590295736514D-04,  -2.387594057381977D-04,   3.953660398960469D-05, &
&   -3.916483492927604D-06,   2.566160403034861D-07,  -1.160676238771884D-08, &
&    3.666565583508408D-10,  -7.981849906041592D-12,   1.145249528309806D-13, &
&   -9.774935269494503D-16,   3.767174990764463D-18,                          &
&    6.494220901289345D-01,  -8.490420525978188D-02,   8.991031952471857D-03, &
&   -6.716759340548150D-04,   3.585549499754719D-05,  -1.380644319212125D-06, &
&    3.818013467313180D-08,  -7.415347328520633D-10,   9.622268049768163D-12, &
&   -7.502826094457377D-14,   2.662048836523615D-16,                          &
&    9.763451976380238D-02,  -2.297515954185633D-02,   2.896289304765988D-03, &
&   -2.355915539916618D-04,   1.322925276552994D-05,  -5.268021181547112D-07, &
&    1.492085140513680D-08,  -2.950302436599047D-10,   3.881995005680668D-12, &
&   -3.060776691517310D-14,   1.095899866750805D-16,                          &
&    2.871220287983898D-02,  -8.042765016198362D-03,   1.103923252535110D-03, &
&   -9.445403931611599D-05,   5.484889583580792D-06,  -2.236955943051612D-07, &
&    6.450158809565818D-09,  -1.293227054667359D-10,   1.720609340283848D-12, &
&   -1.368981618359702D-14,   4.938738352917303D-17,                          &
&    1.085040388718180D-02,  -3.309058279770028D-03,   4.777210976137160D-04, &
&   -4.226716475571880D-05,   2.513653478506554D-06,  -1.043617712745317D-07, &
&    3.051175832720303D-09,  -6.185482799628588D-11,   8.304320026840796D-13, &
&   -6.657085386816482D-15,   2.416915891442326D-17,                          &
&    4.790700802079968D-03,  -1.536570967391369D-03,   2.293679830391540D-04, &
&   -2.078181615481595D-05,   1.258064127401499D-06,  -5.295721266354515D-08, &
&    1.565413294157671D-09,  -3.202113984839770D-11,   4.331241885646877D-13, &
&   -3.494087538963376D-15,   1.275431769220051D-17,                          &
&    2.373791232033080D-03,  -7.871122132713683D-04,   1.203027169660843D-04, &
&   -1.109392188753981D-05,   6.808278768554942D-07,  -2.897266778272641D-08, &
&    8.640682976312688D-10,  -1.780567524091773D-11,   2.423458601711481D-13, &
&   -1.965466624780363D-15,   7.207494842794262D-18,                          &
&    1.290911615789097D-03,  -4.382043148745097D-04,   6.815686747748289D-05, &
&   -6.370803635869283D-06,   3.952056264543971D-07,  -1.696613594960610D-08, &
&    5.096858883799733D-10,  -1.056758924216753D-11,   1.445861641432751D-13, &
&   -1.177931554313311D-15,   4.336612060381118D-18,                          &
&    7.588596469198465D-04,  -2.620807241639723D-04,   4.130965196593480D-05, &
&   -3.902378555698538D-06,   2.441690193879170D-07,  -1.055699218136815D-08, &
&    3.190494088005362D-10,  -6.648823924250838D-12,   9.136988074933542D-14, &
&   -7.472332270310391D-16,   2.760218604999958D-18,                          &
&    4.770829671749194D-04,  -1.669455035627872D-04,   2.658999097314336D-05, &
&   -2.533207489424168D-06,   1.596142937869026D-07,  -6.941865240907307D-09, &
&    2.108482564932575D-10,  -4.412980279369381D-12,   6.087265518570961D-14, &
&   -4.994688893825021D-16,   1.850393110202303D-18,                          &
&    6.370525236722205D-01,  -8.014446830426614D-02,   8.166761995073917D-03, &
&   -5.870783972757502D-04,   3.015699226401256D-05,  -1.117403978690331D-06, &
&    2.973460227518610D-08,  -5.557157140506000D-10,   6.938976314334445D-12, &
&   -5.206428635956190D-14,   1.777577271428381D-16,                          &
&    9.216414061209901D-02,  -2.086993616847706D-02,   2.531672258162924D-03, &
&   -1.981652051681136D-04,   1.070790518233676D-05,  -4.103153539138330D-07, &
&    1.118316118902296D-08,  -2.127835373424631D-10,   2.694181479954399D-12, &
&   -2.044108154477526D-14,   7.042769672006710D-17,                          &
&    2.608463105428707D-02,  -7.031446704646001D-03,   9.287454224455280D-04, &
&   -7.647062795442262D-05,   4.273232481091159D-06,  -1.677100465257717D-07, &
&    4.653544199777408D-09,  -8.978400973949373D-11,   1.149519793180288D-12, &
&   -8.801184007188553D-15,   3.055401539856617D-17,                          &
&    9.488980440080264D-03,  -2.785002017186591D-03,   3.869347458861383D-04, &
&   -3.294611485949693D-05,   1.885560748852964D-06,  -7.533684097034290D-08, &
&    2.119636208340707D-09,  -4.135171418935935D-11,   5.342540754168913D-13, &
&   -4.121450341098684D-15,   1.439952730472877D-17,                          &
&    4.034127593804910D-03,  -1.245308961456637D-03,   1.789047928442340D-04, &
&   -1.560017648096871D-05,   9.088639987938905D-07,  -3.681845602171963D-08, &
&    1.047390967398269D-09,  -2.061824242228272D-11,   2.683852286301445D-13, &
&   -2.083569682004512D-15,   7.319084094603041D-18,                          &
&    1.926470655830604D-03,  -6.148854645826499D-04,   9.045987368575061D-05, &
&   -8.029268893273969D-06,   4.742722828353479D-07,  -1.942535904091297D-08, &
&    5.575844766733255D-10,  -1.105849486908047D-11,   1.448578312070760D-13, &
&   -1.130668894243342D-15,   3.990366301746581D-18,                          &
&    1.010870224023473D-03,  -3.303696093170805D-04,   4.946930845521074D-05, &
&   -4.451481254073653D-06,   2.658284607915824D-07,  -1.098538811592148D-08, &
&    3.176706362552609D-10,  -6.339891483560296D-12,   8.349391395483085D-14, &
&   -6.547299247684694D-16,   2.320061999523958D-18,                          &
&    5.737635221713950D-04,  -1.908027030948057D-04,   2.895666996082477D-05, &
&   -2.633589323329854D-06,   1.586383879011164D-07,  -6.602941925159123D-09, &
&    1.920957507345591D-10,  -3.853472792769423D-12,   5.097357579083362D-14, &
&   -4.012557519436738D-16,   1.426663126620245D-18,                          &
&    3.489999905480465D-04,  -1.176164701156347D-04,   1.803988089096530D-05, &
&   -1.654908588911273D-06,   1.003998688209359D-07,  -4.204069618138048D-09, &
&    1.229344520853347D-10,  -2.476998590476217D-12,   3.289189296044671D-14, &
&   -2.597960947150400D-16,   9.264717516261984D-19,                          &
&    6.253615934593062D-01,  -7.581262518724241D-02,   7.444406294979548D-03, &
&   -5.156899546985054D-04,   2.552661686456294D-05,  -9.114406808588652D-07, &
&    2.337187829088886D-08,  -4.209182919718488D-10,   5.064709515225026D-12, &
&   -3.661958896803200D-14,   1.204805256230828D-16,                          &
&    8.718392923670309D-02,  -1.902441479518986D-02,   2.223888920286889D-03, &
&   -1.677444820453115D-04,   8.734549232933107D-06,  -3.225290760427195D-07, &
&    8.470925562193078D-09,  -1.553172143345092D-10,   1.895063917732708D-12, &
&   -1.385531927070119D-14,   4.600150525931929D-17,                          &
&    2.377957614850926D-02,  -6.177161912664181D-03,   7.862572631252158D-04, &
&   -6.238574472879602D-05,   3.359457721687312D-06,  -1.270553866005170D-07, &
&    3.397337706837805D-09,  -6.316469372393792D-11,   7.793133602903159D-13, &
&   -5.749854767493550D-15,   1.923552679088103D-17,                          &
&    8.337808521462543D-03,  -2.358312503989565D-03,   3.157579551916976D-04, &
&   -2.590951019810485D-05,   1.428999265375091D-06,  -5.502166501966193D-08, &
&    1.491836143754537D-09,  -2.804694947535096D-11,   3.491976523115561D-13, &
&   -2.595996487330145D-15,   8.740417224573100D-18,                          &
&    3.417769697088143D-03,  -1.016829315959023D-03,   1.407879756987166D-04, &
&   -1.183154248562582D-05,   6.643168744912413D-07,  -2.593601686974971D-08, &
&    7.110581318251597D-10,  -1.348975739525361D-11,   1.692252996046664D-13, &
&   -1.266097500144140D-15,   4.286144417762410D-18,                          &
&    1.574624498448413D-03,  -4.844404666740800D-04,   6.869498508757295D-05, &
&   -5.877064463404054D-06,   3.345963157130208D-07,  -1.320887585406285D-08, &
&    3.654315563528183D-10,  -6.985311363169137D-12,   8.819063042037069D-14, &
&   -6.634427331057138D-16,   2.256656715331853D-18,                          &
&    7.971729748036593D-04,  -2.511338478658853D-04,   3.624727899731961D-05, &
&   -3.143886311942556D-06,   1.809574052105637D-07,  -7.207656985173939D-09, &
&    2.008870551769532D-10,  -3.864080764137420D-12,   4.904591298127819D-14, &
&   -3.706710576717136D-16,   1.265901816621619D-18,                          &
&    4.374935515135340D-04,  -1.402728671105788D-04,   2.052429654124228D-05, &
&   -1.799620852035606D-06,   1.045056088269715D-07,  -4.193282241451567D-09, &
&    1.176002530206979D-10,  -2.274084662393427D-12,   2.899708889050999D-14, &
&   -2.200278658184897D-16,   7.540809905863686D-19,                          &
&    2.572658741210593D-04,  -8.359916398827488D-05,   1.236281941262930D-05, &
&   -1.093414027291041D-06,   6.395144011334275D-08,  -2.581523071028889D-09, &
&    7.277014274376235D-11,  -1.413400809564676D-12,   1.809157869015756D-14, &
&   -1.377392397505056D-16,   4.734622436888236D-19,                          &
&    6.142906113358842D-01,  -7.185711293300904D-02,   6.808385834492408D-03, &
&   -4.550812648715573D-04,   2.173602315554722D-05,  -7.488626105011409D-07, &
&    1.852911374519289D-08,  -3.219930647412514D-10,   3.738448068342760D-12, &
&   -2.608187340550105D-14,   8.280014556339111D-17,                          &
&    8.263612069653212D-02,  -1.739937942159206D-02,   1.962567375980085D-03, &
&   -1.428396827335222D-04,   7.176793420397354D-06,  -2.557103693622289D-07, &
&    6.480374272907289D-09,  -1.146512621674105D-10,   1.349812437679506D-12, &
&   -9.522626040030188D-15,   3.050725947455475D-17,                          &
&    2.174851740940484D-02,  -5.451344366935293D-03,   6.695268016170951D-04, &
&   -5.125981325903317D-05,   2.663477239197949D-06,  -9.719880482690268D-08, &
&    2.507809513596074D-09,  -4.499023030812589D-11,   5.356042369876415D-13, &
&   -3.813088883084759D-15,   1.230870774901503D-17,                          &
&    7.358970880901110D-03,  -2.008476121240938D-03,   2.594887200687529D-04, &
&   -2.054571180011501D-05,   1.093429877596466D-06,  -4.062458178890816D-08, &
&    1.062850019479955D-09,  -1.928109700710374D-11,   2.316393493327560D-13, &
&   -1.661650914560605D-15,   5.398366398242404D-18,                          &
&    2.911373709814607D-03,  -8.358246906178318D-04,   1.116713668214561D-04, &
&   -9.055748177216044D-06,   4.906399215290926D-07,  -1.848390520563835D-08, &
&    4.889865308297558D-10,  -8.951503093153243D-12,   1.083567688542599D-13, &
&   -7.822685788967680D-16,   2.555363639227143D-18,                          &
&    1.294448588436286D-03,  -3.842835485602117D-04,   5.258174008565788D-05, &
&   -4.340748213011868D-06,   2.384601403724560D-07,  -9.083386391942728D-09, &
&    2.424780842207787D-10,  -4.472334980391815D-12,   5.448174789112925D-14, &
&   -3.954670015230841D-16,   1.297923120653127D-18,                          &
&    6.325901778355617D-04,  -1.922973691805437D-04,   2.678139950428101D-05, &
&   -2.241336896765190D-06,   1.244780450410307D-07,  -4.783888538024353D-09, &
&    1.286484569182209D-10,  -2.387592727420826D-12,   2.923980993403643D-14, &
&   -2.132135281544446D-16,   7.025504734491565D-19,                          &
&    3.358809494112889D-04,  -1.039417301274010D-04,   1.467825444822313D-05, &
&   -1.242127017780400D-06,   6.961356432963825D-08,  -2.695685799579858D-09, &
&    7.295868379026467D-11,  -1.361515082421917D-12,   1.675373392687982D-14, &
&   -1.226792849068749D-16,   4.057358625631726D-19,                          &
&    1.911106213801747D-04,  -5.994587611144982D-05,   8.556803790158664D-06, &
&   -7.304654277235225D-07,   4.123563024442848D-08,  -1.606547630436415D-09, &
&    4.370745928213580D-11,  -8.193002806545641D-13,   1.012095347590386D-14, &
&   -7.436396293037585D-17,   2.466854675240513D-19,                          &
&    6.037861907461388D-01,  -6.823354197279989D-02,   6.245849536304110D-03, &
&   -4.033256902975883D-04,   1.861088227835864D-05,  -6.194544084497036D-07, &
&    1.480752802161226D-08,  -2.485968055061874D-10,   2.788443749313268D-12, &
&   -1.879451975094860D-14,   5.764290679680954D-17,                          &
&    7.846947961079055D-02,  -1.596193059535632D-02,   1.739391218394815D-03, &
&   -1.223046221694480D-04,   5.936712452541855D-06,  -2.043552420455895D-07, &
&    5.003336613923912D-09,  -8.551868089522662D-11,   9.726989374009107D-13, &
&   -6.629563906369701D-15,   2.051894400128846D-17,                          &
&    1.995350482550128D-02,  -4.832019795454209D-03,   5.733615566339616D-04, &
&   -4.241047751422106D-05,   2.129024914530912D-06,  -7.506342989218533D-08, &
&    1.871103897837211D-09,  -3.243079801274821D-11,   3.730093297168881D-13, &
&   -2.565601054214134D-15,   8.001315911751786D-18,                          &
&    6.523119910861506D-03,  -1.720055713818493D-03,   2.146996413410867D-04, &
&   -1.642368361454823D-05,   8.444549970098572D-07,  -3.031170810183188D-08, &
&    7.661772260057633D-10,  -1.342841079098365D-11,   1.558621896624305D-13, &
&   -1.080198992339809D-15,   3.390485556789919D-18,                          &
&    2.494645421291609D-03,  -6.920090045705840D-04,   8.933521880674360D-05, &
&   -6.999844717127186D-06,   3.664453447984951D-07,  -1.333894691532301D-08, &
&    3.409616709019451D-10,  -6.030939490546138D-12,   7.053829947467107D-14, &
&   -4.920445713094117D-16,   1.553032883468315D-18,                          &
&    1.072385187866220D-03,  -3.076398267689170D-04,   4.067686758460900D-05, &
&   -3.244862810119813D-06,   1.722520864444672D-07,  -6.340324389097433D-09, &
&    1.635495921281941D-10,  -2.914896143483662D-12,   3.431233459237387D-14, &
&   -2.406682558853506D-16,   7.632482903576261D-19,                          &
&    5.066608753251116D-04,  -1.488358549014349D-04,   2.003096851413154D-05, &
&   -1.619966722216020D-06,   8.693974433659415D-08,  -3.228718264338588D-09, &
&    8.390241052361285D-11,  -1.504694992251122D-12,   1.780652042430801D-14, &
&   -1.254682222240490D-16,   3.994932103054470D-19,                          &
&    2.602646567567832D-04,  -7.783839495774862D-05,   1.062293549943437D-05, &
&   -8.687512838391726D-07,   4.705184135754989D-08,  -1.760759536442012D-09, &
&    4.605228157748586D-11,  -8.304928604268143D-13,   9.875537025450927D-15, &
&   -6.987998288753924D-17,   2.233338433373290D-19,                          &
&    1.430632772267832D-04,  -4.336206245402522D-05,   5.980785149061424D-06, &
&   -4.933243378258660D-07,   2.690811511119502D-08,  -1.012918767537513D-09, &
&    2.662566650640719D-11,  -4.822211929189668D-13,   5.755431999913767D-15, &
&   -4.085714216845472D-17,   1.309465824050672D-19,                          &
&    5.938024022909313D-01,  -6.490445424802703D-02,   5.746273243581612D-03, &
&   -3.588964581982886D-04,   1.601766277385748D-05,  -5.156568596479197D-07, &
&    1.192212457017494D-08,  -1.935916639401380D-10,   2.100261602274131D-12, &
&   -1.369189353827128D-14,   4.061620222997030D-17,                          &
&    7.464226770106359D-02,  -1.468562714694129D-02,   1.547845673876643D-03, &
&   -1.052681160732765D-04,   4.942240691986903D-06,  -1.645462046078373D-07, &
&    3.896604586285845D-09,  -6.441877517029697D-11,   7.086880314770090D-13, &
&   -4.671831206927459D-15,   1.398566289004523D-17,                          &
&    1.835627533347389D-02,  -4.299325778723710D-03,   4.934084992369412D-04, &
&   -3.529862444820351D-05,   1.713847241995837D-06,  -5.844222241674552D-08, &
&    1.408975354277754D-09,  -2.361949148044868D-11,   2.627485154499131D-13, &
&   -1.747904241983961D-15,   5.272276036512182D-18,                          &
&    5.804138158182410D-03,  -1.480245123516967D-03,   1.787027000051343D-04, &
&   -1.322144807204787D-05,   6.574968283084364D-07,  -2.282634345322926D-08, &
&    5.580384031551951D-10,  -9.459507763290966D-12,   1.061925265417158D-13, &
&   -7.118138352145851D-16,   2.160898017319665D-18,                          &
&    2.145609193419233D-03,  -5.755784732247484D-04,   7.185647022782482D-05, &
&   -5.444794034059901D-06,   2.756460278986513D-07,  -9.703161230154380D-09, &
&    2.398535830066071D-10,  -4.102743888516022D-12,   4.640482154827832D-14, &
&   -3.130337773389488D-16,   9.554677664834764D-19,                          &
&    8.939542841922061D-04,  -2.481017809874704D-04,   3.173629866847552D-05, &
&   -2.449206551564505D-06,   1.257803801618094D-07,  -4.478972867327648D-09, &
&    1.117723294924689D-10,  -1.927193265350556D-12,   2.194670707470258D-14, &
&   -1.489204997610147D-16,   4.568964993466788D-19,                          &
&    4.086550637139853D-04,  -1.161358784097491D-04,   1.512088125857042D-05, &
&   -1.183027726158829D-06,   6.142123580965490D-08,  -2.206681567024258D-09, &
&    5.547425552316939D-11,  -9.624351060668660D-13,   1.101809637540381D-14, &
&   -7.510425069851137D-17,   2.313355223285309D-19,                          &
&    2.031925139384433D-04,  -5.879174285307104D-05,   7.762323368345029D-06, &
&   -6.141334471317083D-07,   3.217806500732580D-08,  -1.164918956574687D-09, &
&    2.947514276758163D-11,  -5.142174928770579D-13,   5.915278651935956D-15, &
&   -4.049192635502091D-17,   1.251898708788887D-19,                          &
&    1.079066411622071D-04,  -3.163425773086562D-05,   4.220132245669012D-06, &
&   -3.366773541322177D-07,   1.776120011086461D-08,  -6.466453554746836D-10, &
&    1.643955228365850D-11,  -2.879583619410500D-13,   3.323928152439679D-15, &
&   -2.282068992946470D-17,   7.073578228954666D-20,                          &
&    5.842974551276863D-01,  -6.183735331230668D-02,   5.300872462814785D-03, &
&   -3.205644018800396D-04,   1.385257961209665D-05,  -4.317954359381974D-07, &
&    9.666227128474496D-09,  -1.519765002256621D-10,   1.596430368111443D-12, &
&   -1.007690720761019D-14,   2.894346843404740D-17,                          &
&    7.111324193095124D-02,  -1.354676629499092D-02,   1.382447362904400D-03, &
&   -9.103238624362535D-05,   4.138104248862094D-06,  -1.333964269658397D-07, &
&    3.058593739092674D-09,  -4.895841982172444D-11,   5.214946323008249D-13, &
&   -3.328603378400418D-15,   9.648026177704847D-18,                          &
&    1.693404328754364D-02,  -3.840319256566905D-03,   4.267413709783880D-04, &
&   -2.956019799369764D-05,   1.389675505112375D-06,  -4.588387231142993D-08, &
&    1.071097742965246D-09,  -1.738557054345194D-11,   1.872628841359659D-13, &
&   -1.206208676481030D-15,   3.522870462644031D-18,                          &
&    5.186272637879042D-03,  -1.280809755302156D-03,   1.497322902037116D-04, &
&   -1.072745627162812D-05,   5.165885851164215D-07,  -1.736684650698704D-08, &
&    4.111329285868981D-10,  -6.748703797187054D-12,   7.336341709375488D-14, &
&   -4.761961924060882D-16,   1.399870299079026D-18,                          &
&    1.856400410977242D-03,  -4.822268030912436D-04,   5.829592915352345D-05, &
&   -4.277393373487295D-06,   2.096885699876010D-07,  -7.147620608197661D-09, &
&    1.710880446914167D-10,  -2.833825378780666D-12,   3.103752333774854D-14, &
&   -2.027404953037014D-16,   5.992261937907282D-19,                          &
&    7.469150428470804D-04,  -2.006285887006558D-04,   2.483852140085874D-05, &
&   -1.855243930131690D-06,   9.221347182854067D-08,  -3.178085525985875D-09, &
&    7.675859650771858D-11,  -1.280924501407475D-12,   1.411800071658741D-14, &
&   -9.271798169693075D-17,   2.753170436473868D-19,                          &
&    3.323430403644940D-04,  -9.149064359441842D-05,   1.153895732444804D-05, &
&   -8.745052320139198D-07,   4.398079556886668D-08,  -1.530595436502776D-09, &
&    3.727243415100418D-11,  -6.263869266109589D-13,   6.946279954865331D-15, &
&   -4.586531091892080D-17,   1.368472134578593D-19,                          &
&    1.605616083545936D-04,  -4.501908810466059D-05,   5.759913639932143D-06, &
&   -4.415996894949488D-07,   2.242156342825714D-08,  -7.865749175109724D-10, &
&    1.928578826808742D-11,  -3.260350576723193D-13,   3.634357906856096D-15, &
&   -2.410766575138841D-17,   7.222532261767030D-20,                          &
&    8.191879585482461D-05,  -2.324787304904618D-05,   3.002192850266103D-06, &
&   -2.318519306656365D-07,   1.183998735352462D-08,  -4.172779909271452D-10, &
&    1.026900406416753D-11,  -1.741189434372323D-13,   1.945562540050349D-15, &
&   -1.293001648418043D-17,   3.879590905454930D-20,                          &
&    5.752372347356845D-01,  -5.900517770133012D-02,   4.902449692063657D-03, &
&   -2.873478631399239D-04,   1.203512348167562D-05,  -3.636013521399351D-07, &
&    7.889188153013041D-09,  -1.202208970776232D-10,   1.224001763779016D-12, &
&   -7.488385470796813D-15,   2.084686276662484D-17,                          &
&    6.785742269172551D-02,  -1.252893529808357D-02,   1.239250473270247D-03, &
&   -7.909311790283020D-05,   3.484791490192971D-06,  -1.088810980062474D-07, &
&    2.419710113790053D-09,  -3.754071269907780D-11,   3.875777781825216D-13, &
&   -2.397757787622279D-15,   6.736220562417818D-18,                          &
&    1.566360352435844D-02,  -3.443111473165549D-03,   3.708526963206826D-04, &
&   -2.489987572670625D-05,   1.134636124313558D-06,  -3.631255848779880D-08, &
&    8.216364513007833D-10,  -1.292687582835098D-11,   1.349617201173185D-13, &
&   -8.426279235747969D-16,   2.385419759723471D-18,                          &
&    4.646155749007498D-03,  -1.111930396270659D-03,   1.259689058504870D-04, &
&   -8.745807866838291D-06,   4.081348349871272D-07,  -1.329645615690283D-08, &
&    3.050378253738797D-10,  -4.852312006318819D-12,   5.111698740030204D-14, &
&   -3.215358512378423D-16,   9.159874337406731D-19,                          &
&    1.614621975346987D-03,  -4.066156325616991D-04,   4.765458673776456D-05, &
&   -3.389843812681532D-06,   1.611052021249538D-07,  -5.323912707101836D-09, &
&    1.235446841145674D-10,  -1.983868174848130D-12,   2.106504948666041D-14, &
&   -1.333988287260514D-16,   3.822423418309033D-19,                          &
&    6.269654514738540D-04,  -1.631317439596372D-04,   1.956337622491462D-05, &
&   -1.415437545481475D-06,   6.814829061783274D-08,  -2.275078589008608D-09, &
&    5.322644383164173D-11,  -8.603852855157018D-13,   9.185675616666823D-15, &
&   -5.843456515797864D-17,   1.680762668194859D-19,                          &
&    2.712704087389776D-04,  -7.238069667741781D-05,   8.847949117590522D-06, &
&   -6.499325493547774D-07,   3.168098982082025D-08,  -1.068626432998792D-09, &
&    2.522221504868565D-11,  -4.108358423069103D-13,   4.415789475811906D-15, &
&   -2.825993607735511D-17,   8.172480905169376D-20,                          &
&    1.277979290964606D-04,  -3.475754093348260D-05,   4.313564483521583D-06, &
&   -3.207856952645047D-07,   1.579851090228144D-08,  -5.375918223566451D-10, &
&    1.278529218901065D-11,  -2.096509276151469D-13,   2.266825181935029D-15, &
&   -1.458485301303293D-17,   4.238300428662031D-20,                          &
&    6.424498058277825D-05,  -1.771719676152440D-05,   2.223323276261524D-06, &
&   -1.668489165889738D-07,   8.279597255480061D-09,  -2.835473682999733D-10, &
&    6.780593233341091D-12,  -1.117176595263003D-13,   1.212983221989645D-15, &
&   -7.833213091502570D-18,   2.283787199779989D-20,                          &
&    5.665843274940442D-01,  -5.638233419163272D-02,   4.544663570286773D-03, &
&   -2.584238148444758D-04,   1.050053396136480D-05,  -3.077676008943323D-07, &
&    6.478382767520860D-09,  -9.577484111797244D-11,   9.459997248753682D-13, &
&   -5.614808571481560D-15,   1.516441184909078D-17,                          &
&    6.484269526584474D-02,  -1.161503856712390D-02,   1.114573307113654D-03, &
&   -6.901310376614677D-05,   2.949940426606762D-06,  -8.941961399007869D-08, &
&    1.927914442456671D-09,  -2.901825657768391D-11,   2.906513379692628D-13, &
&   -1.744470749345014D-15,   4.754664458185347D-18,                          &
&    1.451566993197208D-02,  -3.095103878026971D-03,   3.233736804542043D-04, &
&   -2.106104101907349D-05,   9.309343017169112D-07,  -2.890010340960327D-08, &
&    6.343116944015699D-10,  -9.680491848346806D-12,   9.803826871462350D-14, &
&   -5.937483490054293D-16,   1.630471752045768D-18,                          &
&    4.176457538343848D-03,  -9.695434707195596D-04,   1.065438473815319D-04, &
&   -7.175303093229657D-06,   3.248024195275857D-07,  -1.026423884584254D-08, &
&    2.284124519647312D-10,  -3.524439204842677D-12,   3.601486361567658D-14, &
&   -2.197460836291005D-16,   6.072345478896875D-19,                          &
&    1.405140421942053D-03,  -3.431004436566866D-04,   3.898793228735916D-05, &
&   -2.689016318834529D-06,   1.239114820244425D-07,  -3.970280131264689D-09, &
&    8.933107036904309D-11,  -1.390847647125471D-12,   1.431916008899353D-14, &
&   -8.792156995333936D-17,   2.442702760723893D-19,                          &
&    5.326673775046233D-04,  -1.345486893123104D-04,   1.566437598158792D-05, &
&   -1.100241778721133D-06,   5.142571928901298D-08,  -1.666670244638876D-09, &
&    3.785371474783849D-11,  -5.940209028197159D-13,   6.156692980851421D-15, &
&   -3.802189888618086D-17,   1.061690521862699D-19,                          &
&    2.211431092735032D-04,  -5.718016382721020D-05,   6.773573042178382D-06, &
&   -4.821665213455758D-07,   2.277624557332032D-08,  -7.445006230527116D-10, &
&    1.702861469938277D-11,  -2.687958717933919D-13,   2.799768225173393D-15, &
&   -1.736383554721545D-17,   4.866206401760942D-20,                          &
&    1.017229780106467D-04,  -2.683683864344365D-05,   3.230773473031967D-06, &
&   -2.330633950529601D-07,   1.113435731485726D-08,  -3.675299477211311D-10, &
&    8.478969008700331D-12,  -1.348723082146576D-13,   1.414617419684269D-15, &
&   -8.829160527658540D-18,   2.488897062604264D-20,                          &
&    4.901084875260231D-05,  -1.309230151478933D-05,   1.591446934860818D-06, &
&   -1.156863967706749D-07,   5.560815066278980D-09,  -1.844702496403152D-10, &
&    4.273081293069325D-12,  -6.819765368664269D-14,   7.172623515272824D-16, &
&   -4.486838183207624D-18,   1.267170314206863D-20,                          &
&    5.583139222719051D-01,  -5.394919191089017D-02,   4.222521585174856D-03, &
&   -2.331477208550018D-04,   9.198961094200695D-06,  -2.618058278475313D-07, &
&    5.351213553031230D-09,  -7.681864503179143D-11,   7.367768845533297D-13, &
&   -4.246293133773443D-15,   1.113604249266038D-17,                          &
&    6.204050998025168D-02,  -1.079058207765269D-02,   1.005409713389765D-03, &
&   -6.044724728626017D-05,   2.508817395486912D-06,  -7.384136977514654D-08, &
&    1.545845786808349D-09,  -2.259235442066189D-11,   2.197225239926196D-13, &
&   -1.280496311733086D-15,   3.388809942023983D-18,                          &
&    1.349143692387826D-02,  -2.793734245386201D-03,   2.834676078512917D-04, &
&   -1.792947941573244D-05,   7.696550553436651D-07,  -2.320416309424683D-08, &
&    4.946053645234866D-10,  -7.330663634270572D-12,   7.209936514055700D-14, &
&   -4.240610017497570D-16,   1.130913754542668D-18,                          &
&    3.772235809470663D-03,  -8.506051479551589D-04,   9.079450825582064D-05, &
&   -5.939398582840824D-06,   2.611517998705470D-07,  -8.016274856049184D-09, &
&    1.732759327971652D-10,  -2.597058012881380D-12,   2.577787417067368D-14, &
&   -1.527779600713234D-16,   4.100821023210945D-19,                          &
&    1.232660505104905D-03,  -2.923521166191211D-04,   3.226833301801942D-05, &
&   -2.161729209508130D-06,   9.675671082582569D-08,  -3.011289832930710D-09, &
&    6.581061979812223D-11,  -9.952569407810153D-13,   9.952577971928378D-15, &
&   -5.935756091628450D-17,   1.601821003991901D-19,                          &
&    4.560694801489039D-04,  -1.119942344445613D-04,   1.267566490979826D-05, &
&   -8.655405698931523D-07,   3.932978014421958D-08,  -1.239175687208012D-09, &
&    2.736112720625006D-11,  -4.174165967622878D-13,   4.205893009621281D-15, &
&   -2.525151870091305D-17,   6.854801123674801D-20,                          &
&    1.805771341730931D-04,  -4.525631016205130D-05,   5.196273069049096D-06, &
&   -3.585152452523817D-07,   1.641440684731558D-08,  -5.200399134574919D-10, &
&    1.152857360397725D-11,  -1.763760464538634D-13,   1.780557315410717D-15, &
&   -1.070267991678815D-17,   2.907010025370120D-20,                          &
&    8.377028683458002D-05,  -2.153322265480317D-05,   2.525689015125732D-06, &
&   -1.775138418877136D-07,   8.262230946030011D-09,  -2.656980040382528D-10, &
&    5.971610515680473D-12,  -9.253663090528822D-14,   9.455011760303095D-16, &
&   -5.748631632334269D-18,   1.578570264559425D-20,                          &
&    4.128767197741602D-05,  -1.080420676812653D-05,   1.286413039746872D-06, &
&   -9.158941341703307D-08,   4.311616370134017D-09,  -1.400655245625975D-10, &
&    3.176980150599012D-12,  -4.964516475374312D-14,   5.111943425425194D-16, &
&   -3.130514592384911D-18,   8.654560213008666D-21,                          &
&    5.503847459614396D-01,  -5.168314498981647D-02,   3.931082760420748D-03, &
&   -2.109347166388415D-04,   8.087839307178819D-06,  -2.236918419090095D-07, &
&    4.443247286035929D-09,  -6.198583721662845D-11,   5.777496753208560D-13, &
&   -3.235875775646450D-15,   8.246908233555298D-18,                          &
&    5.944021782302667D-02,  -1.004739734150403D-02,   9.098204764642250D-04, &
&   -5.316102390106970D-05,   2.144323440855485D-06,  -6.133744348020575D-08, &
&    1.247949559888716D-09,  -1.772546147655793D-11,   1.675390635166560D-13, &
&   -9.489111194971194D-16,   2.440621143693303D-18,                          &
&    1.255721912890849D-02,  -2.526708504239614D-03,   2.491200395946723D-04, &
&   -1.531117326544337D-05,   6.386646446203825D-07,  -1.871022492535331D-08, &
&    3.875329778913022D-10,  -5.581234550669674D-12,   5.334036164538148D-14, &
&   -3.048532151098585D-16,   7.900057581188568D-19,                          &
&    3.404155454719386D-03,  -7.454160512717547D-04,   7.726637109625314D-05, &
&   -4.908328591915277D-06,   2.095773914712409D-07,  -6.247183811305548D-09, &
&    1.311324693948616D-10,  -1.908595909976968D-12,   1.839669541687537D-14, &
&   -1.058799788649039D-16,   2.759843253256715D-19,                          &
&    1.090017614666549D-03,  -2.515520046192508D-04,   2.701653973401248D-05, &
&   -1.761109211980900D-06,   7.670047457892742D-08,  -2.322745477101851D-09, &
&    4.939435417434842D-11,  -7.268569811052553D-13,   7.072645909368800D-15, &
&   -4.104451286350943D-17,   1.077769600763076D-19,                          &
&    3.934615953530680D-04,  -9.405936443802151D-05,   1.036359902949366D-05, &
&   -6.889048036010219D-07,   3.047359573397508D-08,  -9.346821416581446D-10, &
&    2.009057716984577D-11,  -2.983692122272434D-13,   2.926623735014706D-15, &
&   -1.710484190870859D-17,   4.520097867758976D-20,                          &
&    1.462549553036999D-04,  -3.547965380727273D-05,   3.943004883946880D-06, &
&   -2.633059017577679D-07,   1.166750630253082D-08,  -3.577432479403942D-10, &
&    7.674923445634253D-12,  -1.136274671329795D-13,   1.110008258823775D-15, &
&   -6.456101331567423D-18,   1.696729568974282D-20,                          &
&    6.726223211263035D-05,  -1.679220064743816D-05,   1.912942714231320D-06, &
&   -1.305822004948110D-07,   5.903164563744079D-09,  -1.843816706153747D-10, &
&    4.025027701726603D-12,  -6.058219968193597D-14,   6.012475877252900D-16, &
&   -3.550762219300392D-18,   9.470932327569168D-21,                          &
&    3.002548541433822D-05,  -7.569733822473724D-06,   8.683684342015179D-07, &
&   -5.956923959951856D-08,   2.702009706909151D-09,  -8.457936270333699D-11, &
&    1.848629562821700D-12,  -2.783748420921193D-14,   2.762305006315120D-16, &
&   -1.630228019966945D-18,   4.343488332165047D-21,                          &
&    5.427973837605092D-01,  -4.957505303740845D-02,   3.667495448533884D-03, &
&   -1.914030471029644D-04,   7.138006338436499D-06,  -1.920164506192081D-07, &
&    3.709649669484554D-09,  -5.033490476449989D-11,   4.563111711400950D-13, &
&   -2.485753660813743D-15,   6.161727807469750D-18,                          &
&    5.700640942904081D-02,  -9.371143993544820D-03,   8.252597148380908D-04, &
&   -4.689476326328082D-05,   1.839575188921781D-06,  -5.117399571080844D-08, &
&    1.012551835159748D-09,  -1.398667640677107D-11,   1.285671368123445D-13, &
&   -7.081683378048938D-16,   1.771367161480110D-18,                          &
&    1.172081109398845D-02,  -2.294272920664251D-03,   2.200515249511028D-04, &
&   -1.315679197470302D-05,   5.338758397951588D-07,  -1.521501179676971D-08, &
&    3.065687474374393D-10,  -4.295121492913104D-12,   3.993255838652506D-14, &
&   -2.220179023138314D-16,   5.596977265941598D-19,                          &
&    3.095087844631063D-03,  -6.595555034984609D-04,   6.653219863426655D-05, &
&   -4.113045165052437D-06,   1.709080448981371D-07,  -4.957815055983865D-09, &
&    1.012754015935741D-10,  -1.434482166595291D-12,   1.345575730289276D-14, &
&   -7.536488950169316D-17,   1.911728703042875D-19,                          &
&    9.542986154503799D-04,  -2.138197697537761D-04,   2.229564344455128D-05, &
&   -1.411067240221613D-06,   5.966663371783039D-08,  -1.754317161986493D-09, &
&    3.622077599257782D-11,  -5.174927966284190D-13,   4.888922174660126D-15, &
&   -2.754629203367330D-17,   7.022823934453253D-20,                          &
&    3.301268130691677D-04,  -7.644218078943439D-05,   8.158261880207590D-06, &
&   -5.252979575087958D-07,   2.250780368185545D-08,  -6.687129737694454D-10, &
&    1.392316871133936D-11,  -2.002963515815614D-13,   1.903105133838329D-15, &
&   -1.077445531316020D-17,   2.758087157150506D-20,                          &
&    1.216501204330547D-04,  -2.868608691140551D-05,   3.098906889557312D-06, &
&   -2.011547854301357D-07,   8.664343468834268D-09,  -2.582356337443496D-10, &
&    5.385240973896921D-12,  -7.749970040378439D-14,   7.359151539626290D-16, &
&   -4.160599640133169D-18,   1.062873230654272D-20,                          &
&    5.833364346971154D-05,  -1.427987540976845D-05,   1.594873649658132D-06, &
&   -1.067224748886038D-07,   4.728745411864931D-09,  -1.447474432986237D-10, &
&    3.096267638210613D-12,  -4.566009392709404D-14,   4.439297111668908D-16, &
&   -2.568028017009034D-18,   6.708688064903056D-21,                          &
&    2.606587718046386D-05,  -6.459368438145804D-06,   7.282728570233459D-07, &
&   -4.909618322577679D-08,   2.188287942067990D-09,  -6.730254675318800D-11, &
&    1.445191631840908D-12,  -2.137834860640980D-14,   2.083750927516306D-16, &
&   -1.207855774394953D-18,   3.160542355440390D-21,                          &
&    5.355181928772092D-01,  -4.760721622513838D-02,   3.428092229491009D-03, &
&   -1.741427000916590D-04,   6.321309672377397D-06,  -1.655169531906325D-07, &
&    3.112512112861536D-09,  -4.110756085962345D-11,   3.627338295969990D-13, &
&   -1.923356318084480D-15,   4.640652715146324D-18,                          &
&    5.474710480991578D-02,  -8.760363018365015D-03,   7.509524879262275D-04, &
&   -4.153735002625146D-05,   1.586079331617579D-06,  -4.294868933508370D-08, &
&    8.272016197947368D-10,  -1.112250123916987D-11,   9.952038153432163D-14, &
&   -5.335965216408640D-16,   1.299211324839442D-18,                          &
&    1.094467591396208D-02,  -2.084439750769841D-03,   1.945217697968630D-04, &
&   -1.131602596276943D-05,   4.467708493974955D-07,  -1.238848006215773D-08, &
&    2.428708106601945D-10,  -3.310740531140956D-12,   2.994881329583187D-14, &
&   -1.620107416098439D-16,   3.973866127261367D-19,                          &
&    2.819942568013528D-03,  -5.851522861207010D-04,   5.747788880898414D-05, &
&   -3.460070012490323D-06,   1.400030477798929D-07,  -3.954758623748627D-09, &
&    7.866642402439925D-11,  -1.085019296141894D-12,   9.910793452334593D-15, &
&   -5.405407197969656D-17,   1.335198313812682D-19,                          &
&    8.465277520079668D-04,  -1.846854715538207D-04,   1.875125528548616D-05, &
&   -1.155529398402425D-06,   4.757570943422383D-08,  -1.362008408263346D-09, &
&    2.738071976871307D-11,  -3.808941877450794D-13,   3.503673113662191D-15, &
&   -1.922124511511314D-17,   4.771287169752576D-20,                          &
&    2.795746467254585D-04,  -6.280564746184982D-05,   6.502845437719611D-06, &
&   -4.062030028059481D-07,   1.688470896301165D-08,  -4.866476343434531D-10, &
&    9.829211280196406D-12,  -1.371673023654105D-13,   1.264237058333618D-15, &
&   -6.942891599031056D-18,   1.723945225568785D-20,                          &
&    1.064917298467736D-04,  -2.460508071054664D-05,   2.604498406953830D-06, &
&   -1.656609841368296D-07,   6.992175554248432D-09,  -2.042172436444791D-10, &
&    4.173438610527266D-12,  -5.885927749047186D-14,   5.477499315802848D-16, &
&   -3.035038260517746D-18,   7.599021194603252D-21,                          &
&    5.034931044011198D-05,  -1.207388745265382D-05,   1.320721798839618D-06, &
&   -8.654088261653061D-08,   3.754165721312969D-09,  -1.124878625074645D-10, &
&    2.354989448345249D-12,  -3.398400177699924D-14,   3.232761155784468D-16, &
&   -1.829439464840366D-18,   4.674708638087514D-21,                          &
&    1.468196046344768D-05,  -3.387162370943853D-06,   3.551382765663817D-07, &
&   -2.223773060830937D-08,   9.194387709213113D-10,  -2.619453235058811D-11, &
&    5.202275436543735D-13,  -7.105493134947876D-15,   6.382756688912797D-17, &
&   -3.402724407738428D-19,   8.170215617787591D-22,                          &
&    5.284910025946922D-01,  -4.575757869359831D-02,   3.209000723692623D-03, &
&   -1.587632025651237D-04,   5.612793872097129D-06,  -1.431337832367610D-07, &
&    2.621431708292591D-09,  -3.371919733756387D-11,   2.897822585049146D-13, &
&   -1.496483330572135D-15,   3.516574305181108D-18,                          &
&    5.261742849161785D-02,  -8.199793728754729D-03,   6.845508129106812D-04, &
&   -3.687605597643434D-05,   1.371333476880289D-06,  -3.616434670248259D-08, &
&    6.783513069675846D-10,  -8.882973727844776D-12,   7.740706775557051D-14, &
&   -4.041981183521032D-16,   9.584596914604803D-19,                          &
&    1.023947944189992D-02,  -1.898862516161825D-03,   1.725445077847261D-04, &
&   -9.773613616278759D-06,   3.757283042103780D-07,  -1.014459030093041D-08, &
&    1.936505614528442D-10,  -2.570366692358814D-12,   2.263995752720461D-14, &
&   -1.192519250028402D-16,   2.848131047487355D-19,                          &
&    2.554773665714139D-03,  -5.153760298202176D-04,   4.921504006953340D-05, &
&   -2.880197253667980D-06,   1.132957793861039D-07,  -3.111241374527755D-09, &
&    6.016434636809661D-11,  -8.067183114455502D-13,   7.163514216867408D-15, &
&   -3.798201115458090D-17,   9.120649108347748D-20,                          &
&    7.472784069519641D-04,  -1.585745719937918D-04,   1.565989469665944D-05, &
&   -9.386317500486622D-07,   3.758835514063791D-08,  -1.046645671359774D-09, &
&    2.046513513434954D-11,  -2.768993681559817D-13,   2.477348145215525D-15, &
&   -1.321870113278047D-17,   3.191424452826116D-20,                          &
&    2.383808767368490D-04,  -5.201653547624299D-05,   5.231196464877627D-06, &
&   -3.173811478984436D-07,   1.281318926982218D-08,  -3.586649582796673D-10, &
&    7.035393703505840D-12,  -9.534549888110270D-14,   8.533793958398751D-16, &
&   -4.550948760953625D-18,   1.097277663982316D-20,                          &
&    8.481249961072241D-05,  -1.891613876275040D-05,   1.932676151859487D-06, &
&   -1.186438419131746D-07,   4.832690829770166D-09,  -1.362014143360514D-10, &
&    2.685688035195732D-12,  -3.654328463275554D-14,   3.280679817248976D-16, &
&   -1.753441191015479D-18,   4.234340215539634D-21,                          &
&    3.549746974080511D-05,  -8.135961751540590D-06,   8.508468382496673D-07, &
&   -5.331562506190809D-08,   2.212327568680295D-09,  -6.342335040792325D-11, &
&    1.270691197606667D-12,  -1.755208255021883D-14,   1.598534846117899D-16, &
&   -8.662596647773292D-19,   2.120066490484829D-21,                          &
&    2.011604619712907D-05,  -4.813959303362954D-06,   5.237656343599821D-07, &
&   -3.405095295227109D-08,   1.462685099781101D-09,  -4.332967050571458D-11, &
&    8.956631586783470D-13,  -1.274766530637216D-14,   1.194879915962219D-16, &
&   -6.657514781227879D-19,   1.673728290248350D-21,                          &
&    5.217693649871350D-01,  -4.403379684815709D-02,   3.010060696519994D-03, &
&   -1.451569538398102D-04,   5.002071129691205D-06,  -1.243357199402817D-07, &
&    2.219604119148571D-09,  -2.782900191318066D-11,   2.331180180905149D-13, &
&   -1.173437052015619D-15,   2.687768093955915D-18,                          &
&    5.063617508169367D-02,  -7.691697176838618D-03,   6.259120123716696D-04, &
&   -3.286554031658881D-05,   1.191320111153637D-06,  -3.062354566015386D-08, &
&    5.599114355573867D-10,  -7.146826535194112D-12,   6.070522055812845D-14, &
&   -3.089801952777603D-16,   7.141698460313900D-19,                          &
&    9.622437942725951D-03,  -1.740624599146832D-03,   1.542829456754128D-04, &
&   -8.524677658959459D-06,   3.196712364570914D-07,  -8.419219616427010D-09, &
&    1.567705897975460D-10,  -2.029785985764660D-12,   1.743977718532976D-14, &
&   -8.960695245524726D-17,   2.087603834405924D-19,                          &
&    2.341021570936901D-03,  -4.606109808978433D-04,   4.290072105761462D-05, &
&   -2.448754482988112D-06,   9.394909262462226D-08,  -2.516332287511077D-09, &
&    4.746008255288406D-11,  -6.206771763703649D-13,   5.375565166467074D-15, &
&   -2.779903173406900D-17,   6.510745660349173D-20,                          &
&    6.823626510556452D-04,  -1.419025189022005D-04,   1.373305501514983D-05, &
&   -8.066653606510804D-07,   3.165697907645549D-08,  -8.638373935094613D-10, &
&    1.655241439055942D-11,  -2.194731586450101D-13,   1.924232573798305D-15, &
&   -1.006164016330239D-17,   2.380523688184839D-20,                          &
&    2.148500999812417D-04,  -4.600932913218492D-05,   4.541098647392566D-06, &
&   -2.704032092415792D-07,   1.071456242314219D-08,  -2.943802023955340D-10, &
&    5.667960112894708D-12,  -7.540044136696190D-14,   6.624728143781600D-16, &
&   -3.468145395953846D-18,   8.209163213134792D-21,                          &
&    6.974527197520789D-05,  -1.508824984026992D-05,   1.495077221308227D-06, &
&   -8.900050981561763D-08,   3.514968541921485D-09,  -9.603714354411549D-11, &
&    1.835591152166286D-12,  -2.420615088024308D-14,   2.105775219090030D-16, &
&   -1.090432325980512D-18,   2.550814518188004D-21,                          &
&    3.479147840238582D-05,  -7.936599865688574D-06,   8.257553814160662D-07, &
&   -5.145907706032421D-08,   2.122782881453052D-09,  -6.047875731634420D-11, &
&    1.203780612886951D-12,  -1.651401057032561D-14,   1.493248134818107D-16, &
&   -8.031920802225927D-19,   1.950578872891267D-21,                          &
&    6.378120272148954D-06,  -1.294976578106958D-06,   1.180824555103656D-07, &
&   -6.332147293988566D-09,   2.196230873310560D-10,  -5.098664166291328D-12, &
&    7.901005666759740D-14,  -7.840039672287811D-16,   4.455299655644380D-18, &
&   -1.021635352691834D-20,  -7.568450311473227D-24/
end
