#!/bin/bash

#///////////////////////////////////////////////////////////////////////
#
#      Authors:         S. Ruiz-Barragan, K. Ishimura, M. Shiga
#      Last updated:    May 1, 2016 by M. Shiga
#      Description:     bash script for modify the SMASH code for PIMD
#
#///////////////////////////////////////////////////////////////////////

#-----------------------------------------------------------------------
#      Set sed command.
#-----------------------------------------------------------------------

#sed command: OSX
# SEDCOM='gsed'

#sed command: LINUX
SEDCOM='sed'

#-----------------------------------------------------------------------
#      Get name of SMASH directory taken from the first argument.
#-----------------------------------------------------------------------

DIR=$1

#-----------------------------------------------------------------------
#      Mark changes by creating a new file called "MODIFIED".
#-----------------------------------------------------------------------

FILEMOD=MODIFIED

#-----------------------------------------------------------------------
#      If the mark do not exist, the patch is applied.
#-----------------------------------------------------------------------

if [ ! -f $DIR/$FILEMOD ];
then

#-----------------------------------------------------------------------
#      Change unit from file 6 to file 99 (smash.out).
#-----------------------------------------------------------------------

   $SEDCOM  -i 's/write(\*\,/write(99\,/gI' $DIR/*F90

#-----------------------------------------------------------------------
#      Change unit from file 5 to file 98 (input.dat).
#-----------------------------------------------------------------------

   $SEDCOM  -i 's/read(5\,/read(98\,/gI' $DIR/*F90
   $SEDCOM  -i 's/read(\*\,/read(98\,/gI' $DIR/*F90

#-----------------------------------------------------------------------
#      Change names of subroutines writeeigenvector and calcmaxgrad,
#-----------------------------------------------------------------------

   $SEDCOM  -i 's/ne writeeigenvector/ne writeeigenvector2/gI' $DIR/*F90
   $SEDCOM  -i 's/ne calcmaxgrad/ne calcmaxgrad2/gI' $DIR/*F90

#-----------------------------------------------------------------------
#      Change the main routine of SMASH (not used in PIMD-SMASH).
#-----------------------------------------------------------------------

   $SEDCOM  -i 's/program main/subroutine main_smash/g' $DIR/main.F90

#-----------------------------------------------------------------------
#      Remove parallel setups in SMASH (already done in PIMD).
#-----------------------------------------------------------------------

   $SEDCOM  -i 's/call para_init(/!call para_init(/g' $DIR/main.F90

#-----------------------------------------------------------------------
#      Change communicator of MPI subroutines (optinal).
#-----------------------------------------------------------------------

   $SEDCOM  -i 's/mpi_comm)/mpi_comm1)/g' $DIR/parallel.F90
   $SEDCOM  -i 's/mpi_comm$/mpi_comm1/g' $DIR/parallel.F90

#-----------------------------------------------------------------------
#      Change unit numbers: from 10 to 97 (SMASH input file).
#-----------------------------------------------------------------------

   $SEDCOM  -i 's/input\=10/input\=97/gI' $DIR/module.F90

#-----------------------------------------------------------------------
#      Change unit numbers: from 20 to 96 (SMASH checkpoint file).
#-----------------------------------------------------------------------

   $SEDCOM  -i 's/icheck\=20/icheck\=96/gI' $DIR/module.F90

#-----------------------------------------------------------------------
#      Apply a patch to guess.F90: initial MO guess.
#-----------------------------------------------------------------------

   cd $DIR
   echo "
--- xxx/guess.F90	2016-03-23 00:00:00.000000000 +0900
+++ yyy/guess.F90	2016-03-23 00:00:00.000000000 +0900
@@ -48,6 +48,9 @@
         call updatemo(cmoa,overinv,nproc2,myrank2,mpi_comm2)
         if(scftype == 'UHF') call dcopy(nao*nao,cmoa,1,cmob,1)
 !
+      elseif(guess == 'PIMD') then
+        call savemo(cmoa,cmob,nproc2,myrank2,mpi_comm2)
+!
       elseif(guess == 'CHECK') then
         if(master) write(99,'("   Guess MOs are read from checkpoint file and projected.",/)')
         call checkguess(cmoa,cmob,overinv,nproc2,myrank2,mpi_comm1,mpi_comm2) " | patch

#-----------------------------------------------------------------------
#      use myrank in fileio and ecpfunc.
#-----------------------------------------------------------------------

   $SEDCOM  -i 's/      use modmemory\, only : memory/      use common_variables\, only : myrank\n      use modmemory\, only : memory/g' fileio.F90
   $SEDCOM  -i 's/      use modparallel\, only : master/      use common_variables\, only : myrank\n      use modparallel\, only : master/g' fileio.F90
   $SEDCOM  -i 's/      use modparallel\, only : master/      use common_variables\, only : myrank\n      use modparallel\, only : master/g' ecpfunc.F90

#-----------------------------------------------------------------------
#      Apply a patch to fileio.F90: keywords read from PIMD (input.dat).
#-----------------------------------------------------------------------

   echo "
--- fileio.F90_org      2016-06-22 17:09:28.791373665 +0900
+++ fileio.F90  2016-06-22 17:11:42.343403671 +0900
@@ -36,7 +36,7 @@
       use modmp2, only : ncore, nvfz, maxmp2diis, maxmp2iter
       implicit none
       integer,intent(in) :: mpi_comm
-      integer :: myrank, ii, llen, intarray(16), info
+      integer :: ii, llen, intarray(16), info
       real(8) :: realarray(23)
       character(len=254) :: line
       character(len=16) :: chararray(9), mem=''
@@ -50,13 +50,29 @@
       namelist /dft/ nrad, nleb, threshweight, threshrho, threshdfock, threshdftao, bqrad
       namelist /mp2/ ncore, nvfz, maxmp2diis, maxmp2iter, threshmp2cphf
 !
-      call para_comm_rank(myrank,mpi_comm)
+!     call para_comm_rank(myrank,mpi_comm)

       if(myrank == 0) then
+        open ( 98, file = 'input.dat' )
+        rewind(98)
+        info=0
+        do while (.true.)
+          read ( 98 , '(a)', end=101 ) line
+          if(index(line,'<smash_options>') .ne. 0) then
+            info=1
+            exit
+          endif
+        enddo
+101     IF(info.eq.0) THEN
+          write( 99, * ) 'Error: <smash_options> in input.dat.'
+          call iabort
+        ENDIF
+!
         do ii= 1,maxline
           read(98,'(a)',end=100) line
           line=adjustl(line)
           llen=len_trim(line)
+          if(index(line,'<') .ne. 0) exit
           call low2up(line,llen)
           select case(line(1:3))
             case('JOB')" | patch

#-----------------------------------------------------------------------
#      Close file 98 after reading SMASH keywords from input.dat.
#-----------------------------------------------------------------------

   $SEDCOM  -i 's/100     rewind(input)/100     rewind(input)\n        close(98)/g' fileio.F90

#-----------------------------------------------------------------------
#      Replace "parallel" by "true".
#-----------------------------------------------------------------------

   $SEDCOM  -i 's/if(parallel) then/if(.true.) then/g' fileio.F90

#-----------------------------------------------------------------------
#      Change name of subroutine readatom.
#-----------------------------------------------------------------------

   $SEDCOM  -i 's/ne readatom/ne readatom2/g' fileio.F90

#-----------------------------------------------------------------------
#      Replace "master" by "myrank" in subroutine setdetails.
#-----------------------------------------------------------------------

   $SEDCOM  -i ':a;N;$!ba;s/      character(len=254) :: line\n!\n      if(master) then\n        rewind(input)/      character(len=254) :: line\n!\n!      if(master) then\n      IF(myrank.eq.0) then\n        rewind(input)/g' fileio.F90

#-----------------------------------------------------------------------
#      Replace "master" by "myrank" in subroutine ecpfunc.
#-----------------------------------------------------------------------

   $SEDCOM  -i ':a;N;$!ba;s/      if(master) then/!      if(master) then\n      IF(myrank.eq.0) then/g' ecpfunc.F90

#-----------------------------------------------------------------------
#      Change name of SMASH file: "input.dat(number)" to "smash.inp".
#-----------------------------------------------------------------------

   $SEDCOM  -i ':a;N;$!ba;s/filename= \"input.dat\"\/\/adjustl(filename)/filename= \"smash.inp"/g' machine.F90
   $SEDCOM  -i 's/open(unit=input,file=filename,status='\''replace'\'')/open(unit=input,file=filename,status='\''unknown'\'')/g' machine.F90

#-----------------------------------------------------------------------
#      NEW: Change name of subroutine calcrdipole and calcudipole.
#-----------------------------------------------------------------------

   $SEDCOM  -i 's/ne calcrdipole/ne calcrdipole2/g' scflib.F90
   $SEDCOM  -i 's/ne calcudipole/ne calcudipole2/g' scflib.F90

#-----------------------------------------------------------------------
#      Make input file open only by master process
#-----------------------------------------------------------------------

###   $SEDCOM  -i ':a;N;$!ba;s/      use modparallel, only : master\n      use modiofile, only : input/      use common_variables, only : myrank\n      use modiofile, only : input/g' machine.F90
###   $SEDCOM  -i ':a;N;$!ba;s/      if(master) then\n        iprocess= getpid()/      if(myrank.eq.0) then\n        iprocess= getpid()/g' machine.F90

#-----------------------------------------------------------------------
#      Print messages.
#-----------------------------------------------------------------------

   echo "SMASH source files are modified using modify_smash.sh."
   touch $FILEMOD
   cd ..

fi
