# Interfacing PIMD with Quantum-ESPRESSO

We here describe how to compile PIMD with Quantum-ESPRESSO (QE).

Currently we only support versions 6.2.1 and 6.3.

You can either download the sources in advance or you can download them during the build process.

## Download Quantum-ESPRESSO during build

In the root directory, say ``~/pimd``, make a directory for building pimd.

  > mkdir build

  > cd build

Inside the build directory run the cmake command

  > cmake -DMKLUSE=ON -DQE=ON -DQEVERSION=6.3 ..

Where we note that you can also set ``-DQEVERSION=6.2.1`` if you want to use that version.

After the cmake command has finished without any errors run make with a suitable number of processes, here 10.

   > make -j 10 

Note that the compilation of Quantum-ESPRESSO only uses one process and this process might take some time.

If the make command finishes without errors you are now ready to use PIMD with Quantum-ESPRESSO using the binaries in the build directory.

## Predownloaded sources

If you have already downloaded the sources you can provide the location in the ``-DQEFILES`` when calling cmake

  > cmake -DMKLUSE=ON -DQE=ON -DQEVERSION=6.2.1 -DQEFILES=../lib/qe/q-e-qe-6.2.1.zip ..

Remember that ``-DQEVERSION`` has to match the version of the downloaded files.

Otherwise this method works as the one described above.

# Old method - No cmake

## Prepare makefile for PIMD
In the root directory, say ``~/pimd``, make a copy of source directory named ``compile``, in which PIMD is actually compiled.

  > mkdir compile

  > cp -r source/* compile

Activate the option ``QE = -Dqe`` in ``makefile``, so that QE is linked when PIMD is build.

  > vi source/makefile

Note that the libraries used to build PIMD should be consistent with those for QE (see below).

## Prepare PIMD modules for QE

In the ``~/pimd/compile`` directory, generate the modules necessary to compile the modified QE

  > make common_variables.o

## Download the QE source code

Go to the QE library directory ``~/pimd/lib/qe`` and download and unzip the source code of QE version 6.2.1.

  > cd ~/pimd/lib/qe

  > wget https://github.com/QEF/q-e/archive/qe-6.2.1.zip

  > unzip q-e-qe-6.2.1.zip

Make sure that fftw(3) library for QE is present, see below.

## Apply a patch to QE

In the QE library directory, apply the patch file

  > patch -p0 < qe-6.2.1_to_pimdlib.patch

## Prepare makefile of QE

Configure QE in the ``q-e-qe-6.2.1`` directory

  > cd ~/pimd/lib/qe/q-e-qe-6.2.1

  > ./configure

## Compile QE

Go to the QE directory and compile it.

  > cd ~/pimd/lib/qe/q-e-qe-6.2.1

  > make pw

## Compile and link PIMD and QE

Go to the PIMD compile directory and edit makefile for e.g.

  > vi ~/pimd/compile/makefile

and type ``make`` in the ``compile`` directory to compile PIMD.

