#
#   the following code creates liquid structure
#
#   input  = input.dat ... molecular info
#
#   output = centroid.txyz ... input file of TINKER
#   output = centroid.dat ... initial geometry of PIMD (bohr)
#   output = structure.dat ... initial geometry in xyz format (angstrom)
#   output = geometry.ini ... restart geometry of PIMD (not used)
#

prep_liquid.x

#
# rename files
#

rm centroid.dat
mv structure.txyz oxyluciferin.txyz

#
#   the following code creates force-field parameter file
#
#   input  = amber_oxy.prm ... AMBER parameters in TINKER format
#   input  = oxyluciferin.txyz ... input file of TINKER
#   input  = lennard-jones cutoff radii in bohr (20.0 24.0)
#            ... it is recommended that the outer radius (24.0)
#                is less than half of the box size, while
#                the inner radius (20.0) is more than one bohr
#                smaller than the outer radius.
#
#   output = mm.dat ... parameter file of PIMD
#

convert_tinker.x oxyluciferin.txyz amber_oxy.prm 20.0 24.0 mm.dat tmp.1 tmp.2 tmp.3

#
# remove unnecessary files
#

rm -f tmp.1 tmp.2 tmp.3 geometry.ini

