#!/bin/bash

###   set SINDO path   ###
. /Users/shiga/Downloads/sindo/sindo-4.0_220319/sindovars.sh

###   Step 1: PIMD - Optimize geometry    ###
echo; echo; echo; echo "<<< Entering GEOOPT >>>"; echo; echo; echo
cd GEOOPT
pimd.x
cd ..

###   Step 2: PIMD - Normal mode analysis, create minfo file   ###
echo; echo; echo; echo "<<< Entering NMA >>>"; echo; echo; echo
cd NMA
cp ../GEOOPT/geometry.ini .
pimd.x
echo; echo; echo; echo "<<< nma.out >>>"; echo; echo; echo
cat nma.out
echo; echo; echo; echo "<<< nma.minfo >>>"; echo; echo; echo
cat nma.minfo
cp nma.minfo ../MakePES
cp nma.minfo ../MakeGRID
cp nma.minfo ../FSindo
cd ..

###   Step 3: SINDO - Create structures (MakeGrid.xyz)    ###
echo; echo; echo; echo "<<< Entering makePES >>>"; echo; echo; echo
cd makePES
java RunMakePES -f makePES.xml
cp MakeGrid.xyz ../SCAN/structure.dat
cp makePES.xml ../MakeGRID
cd ..

###   Step 4: PIMD - Potential calculations   ####
echo; echo; echo; echo "<<< Entering SCAN >>>"; echo; echo; echo
cd SCAN
grep -e "mkg" structure.dat > mkg.out
gsed -i "s/mkg-/ANGSTROM mkg-/g" structure.dat
pimd.x
cp mkg.out potential_scan.out dipole_scan.out ../makeGRID
cd ..

###   Step 5: SINDO - Create PES (*.pot,*.dipole)   ####
echo; echo; echo; echo "<<< Entering makeGRID >>>"; echo; echo; echo
cd makeGRID
cut -c 13-36 potential_scan.out > 2
cut -c 13-24 dipole_scan.out > 3
cut -c 25-36 dipole_scan.out > 4
cut -c 37-48 dipole_scan.out > 5
paste -d, mkg.out 2 3 4 5 > makeGRID.dat
rm 2 3 4 5
java RunMakePES -f makePES.xml
cp *.pot *.dipole ../FSindo
cd ..

###   Step 6: SINDO - VSCF, VCI calculations   ####
echo; echo; echo; echo "<<< Entering FSINDO >>>"; echo; echo; echo
cd FSindo
export POTDIR=./
sindo < vscf.inp > vscf.out
sindo < vci.inp > vci.out
cd ..

###   Step 7: View results   ####
echo; echo; echo; echo "<<< vscf.out >>>"; echo; echo; echo;
cat FSindo/vscf.out
echo; echo; echo; echo "<<< vci.out >>>"; echo; echo; echo
cat FSindo/vci.out

